/*
 * Decompiled with CFR 0.152.
 */
package org.ogf.graap.wsag.api.types;

import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;
import org.ogf.graap.wsag.api.Agreement;
import org.ogf.graap.wsag.api.AgreementOffer;
import org.ogf.graap.wsag.api.types.AgreementOfferType;
import org.ogf.graap.wsag.api.types.WSAGXmlType;
import org.ogf.schemas.graap.wsAgreement.AgreementContextType;
import org.ogf.schemas.graap.wsAgreement.AgreementPropertiesDocument;
import org.ogf.schemas.graap.wsAgreement.AgreementPropertiesType;
import org.ogf.schemas.graap.wsAgreement.AgreementRoleType;
import org.ogf.schemas.graap.wsAgreement.AgreementStateDefinition;
import org.ogf.schemas.graap.wsAgreement.AgreementStateType;
import org.ogf.schemas.graap.wsAgreement.GuaranteeTermStateDefinition;
import org.ogf.schemas.graap.wsAgreement.GuaranteeTermStateType;
import org.ogf.schemas.graap.wsAgreement.GuaranteeTermType;
import org.ogf.schemas.graap.wsAgreement.ServiceDescriptionTermType;
import org.ogf.schemas.graap.wsAgreement.ServiceTermStateDefinition;
import org.ogf.schemas.graap.wsAgreement.ServiceTermStateType;
import org.ogf.schemas.graap.wsAgreement.TemplateDocument;
import org.ogf.schemas.graap.wsAgreement.TermTreeType;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAgreementType
extends WSAGXmlType
implements Agreement {
    protected AgreementPropertiesType agreementProperties;
    protected static final String DEFAULT_SDT_XPATH = "declare namespace wsag='http://schemas.ggf.org/graap/2007/03/ws-agreement';$this/wsag:Terms/wsag:All//wsag:ServiceDescriptionTerm";
    protected static final String DEFAULT_GUARANTEE_TERM_XPATH = "declare namespace wsag='http://schemas.ggf.org/graap/2007/03/ws-agreement';$this/wsag:Terms/wsag:All//wsag:GuaranteeTerm";
    private Map<String, XmlObject> persistedExecutionContext = new HashMap<String, XmlObject>();
    private Map<String, Object> transcientExecutionContext = new HashMap<String, Object>();

    public AbstractAgreementType(AgreementOffer offer) {
        this.initialize(offer);
    }

    public AbstractAgreementType(AgreementPropertiesType agreementPropertiesType) {
        this.agreementProperties = agreementPropertiesType;
    }

    public AbstractAgreementType() {
        TemplateDocument templateDoc = TemplateDocument.Factory.newInstance();
        templateDoc.addNewTemplate();
        templateDoc.getTemplate().setAgreementId("ID");
        templateDoc.getTemplate().addNewContext().setServiceProvider(AgreementRoleType.AGREEMENT_RESPONDER);
        TermTreeType terms = templateDoc.getTemplate().addNewTerms();
        Text text = terms.getDomNode().getOwnerDocument().createTextNode(" ");
        terms.getDomNode().appendChild(text);
        this.initialize(new AgreementOfferType(templateDoc.getTemplate()));
    }

    @Override
    public boolean validate() {
        return this.validate((XmlObject)this.agreementProperties);
    }

    protected void initialize(AgreementOffer offer) {
        this.initialize(offer, DEFAULT_SDT_XPATH, DEFAULT_GUARANTEE_TERM_XPATH);
    }

    protected void initialize(AgreementOffer offer, String sdtXPath, String guaranteeTermXPath) {
        this.agreementProperties = AgreementPropertiesDocument.Factory.newInstance().addNewAgreementProperties();
        this.agreementProperties.setAgreementId(offer.getAgreementId());
        this.agreementProperties.addNewContext().set((XmlObject)offer.getContext());
        this.agreementProperties.addNewTerms().set((XmlObject)offer.getTerms());
        this.agreementProperties.addNewAgreementState().setState(AgreementStateDefinition.OBSERVED);
        XmlObject[] sdtArray = offer.getXMLObject().selectPath(sdtXPath);
        for (int i = 0; i < sdtArray.length; ++i) {
            ServiceDescriptionTermType sdt = (ServiceDescriptionTermType)sdtArray[i];
            ServiceTermStateType sdtState = this.agreementProperties.addNewServiceTermState();
            sdtState.setTermName(sdt.getName());
            sdtState.setState(ServiceTermStateDefinition.NOT_READY);
        }
        XmlObject[] guaranteeArray = offer.getXMLObject().selectPath(guaranteeTermXPath);
        for (int i = 0; i < guaranteeArray.length; ++i) {
            GuaranteeTermType guarantee = (GuaranteeTermType)guaranteeArray[i];
            GuaranteeTermStateType guaranteeState = this.agreementProperties.addNewGuaranteeTermState();
            guaranteeState.setTermName(guarantee.getName());
            guaranteeState.setState(GuaranteeTermStateDefinition.NOT_DETERMINED);
        }
    }

    public final void notifyReload(Map<String, XmlObject> executionCtx) {
        this.persistedExecutionContext = executionCtx;
        this.notifyReinitialized(this.persistedExecutionContext);
    }

    protected void notifyReinitialized(Map<String, XmlObject> persistedExecutionCtx) {
    }

    @Override
    public String getAgreementId() {
        return this.agreementProperties.getAgreementId();
    }

    @Override
    public AgreementContextType getContext() {
        return this.agreementProperties.getContext();
    }

    @Override
    public String getName() {
        return this.agreementProperties.getName();
    }

    @Override
    public TermTreeType getTerms() {
        return this.agreementProperties.getTerms();
    }

    public void setAgreementId(String agreementId) {
        this.agreementProperties.setAgreementId(agreementId);
        this.setChanged();
    }

    public void setContext(AgreementContextType context) {
        this.agreementProperties.setContext(context);
        this.setChanged();
    }

    public void setName(String name) {
        this.agreementProperties.setName(name);
        this.setChanged();
    }

    public void setTerms(TermTreeType terms) {
        this.agreementProperties.setTerms(terms);
        this.setChanged();
    }

    @Override
    public AgreementStateType getState() {
        return this.agreementProperties.getAgreementState();
    }

    @Override
    public GuaranteeTermStateType[] getGuaranteeTermStates() {
        GuaranteeTermStateType[] guarateeStates = this.agreementProperties.getGuaranteeTermStateArray();
        if (guarateeStates == null) {
            return new GuaranteeTermStateType[0];
        }
        return guarateeStates;
    }

    @Override
    public ServiceTermStateType[] getServiceTermStates() {
        ServiceTermStateType[] serviceStates = this.agreementProperties.getServiceTermStateArray();
        if (serviceStates == null) {
            return new ServiceTermStateType[0];
        }
        return serviceStates;
    }

    public void setState(AgreementStateType agreementState) {
        this.agreementProperties.setAgreementState(agreementState);
        this.setChanged();
    }

    public void setGuaranteeTermStates(GuaranteeTermStateType[] guaranteeTermStateList) {
        this.agreementProperties.setGuaranteeTermStateArray(guaranteeTermStateList);
        this.setChanged();
    }

    public void setServiceTermStates(ServiceTermStateType[] serviceTermStateList) {
        this.agreementProperties.setServiceTermStateArray(serviceTermStateList);
        this.setChanged();
    }

    public XmlObject getXMLObject() {
        return this.agreementProperties;
    }

    public void setXmlObject(AgreementPropertiesType properties) {
        this.agreementProperties = properties;
        this.setChanged();
    }

    @Override
    public AbstractAgreementType getAgreementInstance() {
        return this;
    }

    public Map<String, XmlObject> getExecutionContext() {
        return this.persistedExecutionContext;
    }

    public Map<String, Object> getTransientExecutionContext() {
        return this.transcientExecutionContext;
    }
}

