/*
 * Decompiled with CFR 0.152.
 */
package net.siisise.abnf;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import net.siisise.abnf.ABNF;
import net.siisise.abnf.ABNFrule;
import net.siisise.abnf.AbstractABNF;
import net.siisise.abnf.parser5234.ABNF5234;
import net.siisise.block.ReadableBlock;
import net.siisise.bnf.BNF;
import net.siisise.bnf.BNFCC;
import net.siisise.bnf.BNFReg;
import net.siisise.bnf.parser.BNFParser;
import net.siisise.io.FrontPacket;
import net.siisise.io.StreamFrontPacket;

public class ABNFReg
extends BNFCC<ABNF> {
    public ABNFReg() {
        this((BNFReg)null, (BNFCC)ABNF5234.REG);
    }

    public ABNFReg(URL url, BNFReg up) throws IOException {
        this(up);
        this.rulelist(url);
    }

    public ABNFReg(BNFReg up) {
        this(up, (BNFCC)ABNF5234.REG);
    }

    public ABNFReg(URL url, BNFReg up, BNFCC ruleParser) throws IOException {
        this(up, ruleParser);
        this.rulelist(url);
    }

    public ABNFReg(BNFReg up, BNFCC ruleParser) {
        super(up, ruleParser, null, null, null, null);
    }

    public ABNFReg(BNFReg up, BNFCC ruleParser, String rulelist, String rule, String rulename, String elements) {
        super(up, ruleParser, rulelist, rule, rulename, elements);
    }

    @Override
    public ABNF ref(String rulename) {
        return new ABNFRef(rulename);
    }

    @Override
    public ABNF href(String rulename) {
        ABNF bnf = (ABNF)this.reg.get(rulename);
        if (bnf == null) {
            bnf = new ABNFRef(rulename);
        }
        return bnf;
    }

    public List<ABNF> rulelist(String rulelist) {
        List list = (List)this.bnfReg.parse(this.bnfReg.rulelist, rulelist, (Object)this);
        if (list != null) {
            list.forEach(abnf -> this.reg.put(abnf.getName(), abnf));
        }
        return list;
    }

    public List<ABNF> rulelist(FrontPacket rulelist) {
        List list = (List)this.bnfReg.parse("rulelist", rulelist, (Object)this);
        if (list != null) {
            list.forEach(abnf -> this.reg.put(abnf.getName(), abnf));
        }
        return list;
    }

    public List<ABNF> rulelist(ReadableBlock rulelist) {
        List list = (List)this.bnfReg.parse("rulelist", rulelist, (Object)this);
        if (list != null) {
            list.forEach(abnf -> this.reg.put(abnf.getName(), abnf));
        }
        return list;
    }

    public List<ABNF> rulelist(URL url) throws IOException {
        InputStream in = url.openStream();
        List<ABNF> rl = this.rulelist((FrontPacket)new StreamFrontPacket(in));
        in.close();
        return rl;
    }

    String javaLine(String ruleName, String regName, ABNFrule rule) {
        StringBuilder src = new StringBuilder();
        src.append("\r\n    static final ABNF ");
        src.append(ruleName.replace('-', '_')).append(" = ").append(regName);
        src.append(".rule(\"").append(ruleName).append("\",");
        src.append(rule.bnf.toJava());
        src.append(");");
        return src.toString();
    }

    @Override
    public String toJava(String regName) {
        StringBuilder src = new StringBuilder();
        src.append("class Example {");
        src.append("\r\n    static final ABNFReg ").append(regName).append(" = new ABNFReg();");
        src.append("\r\n");
        for (String ruleName : this.reg.keySet()) {
            ABNFrule bnf = (ABNFrule)this.reg.get(ruleName);
            src.append(this.javaLine(ruleName, regName, bnf));
        }
        src.append("\r\n}");
        return src.toString();
    }

    public class ABNFRef
    extends AbstractABNF {
        ABNFRef(String rulename) {
            this.name = rulename;
        }

        @Override
        public ReadableBlock is(ReadableBlock src) {
            return ((ABNF)ABNFReg.this.reg.get(this.name)).is(src);
        }

        @Override
        public ReadableBlock is(ReadableBlock src, Object ns) {
            return ((ABNF)ABNFReg.this.reg.get(this.name)).is(src, ns);
        }

        @Override
        public <X> BNF.Match<X> find(ReadableBlock pac, Object ns, BNFParser<? extends X> ... parsers) {
            return ((ABNF)ABNFReg.this.reg.get(this.name)).find(pac, ns, parsers);
        }

        @Override
        public ABNF copy(BNFReg<ABNF> reg) {
            return reg.ref(this.name);
        }

        @Override
        public String toJava() {
            return "REG.ref(\"" + this.name + "\")";
        }
    }
}

