/*
 * Decompiled with CFR 0.152.
 */
package net.siisise.abnf;

import java.util.Arrays;
import net.siisise.abnf.ABNF;
import net.siisise.abnf.IsABNF;
import net.siisise.block.ByteBlock;
import net.siisise.block.ReadableBlock;
import net.siisise.bnf.BNFReg;
import net.siisise.lang.CodePoint;

public class ABNFbin
extends IsABNF {
    private final byte[] data;

    ABNFbin(int ch) {
        this.name = ch >= 32 && (ch != 34 && ch < 65 || ch > 90 && ch < 97 || ch > 122 && ch < 127) ? "\"" + (char)ch + "\"" : this.uhex(ch);
        this.data = CodePoint.utf8((int)ch);
    }

    ABNFbin(String str) {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.uhex(str.charAt(0)));
        for (int i = 1; i < str.length(); ++i) {
            sb.append(".");
            sb.append(this.uhex(str.charAt(i)).substring(2));
        }
        this.name = sb.toString();
        this.data = str.getBytes(UTF8);
    }

    ABNFbin(byte[] src) {
        this.data = src;
        this.name = "\u30d0\u30a4\u30c8\u5217(" + src.length + ")";
        StringBuilder sb = new StringBuilder();
        if (src.length > 0) {
            sb.append("%x");
            sb.append(ABNFbin.binHex(src[0]));
            for (int i = 1; i < src.length; ++i) {
                sb.append('.').append(ABNFbin.binHex(src[i]));
            }
            this.name = sb.toString();
        }
    }

    static String binHex(byte b) {
        return Integer.toHexString(256 + (b & 0xFF)).substring(1).toUpperCase();
    }

    @Override
    public ABNFbin copy(BNFReg<ABNF> reg) {
        return new ABNFbin(new String(this.data, UTF8));
    }

    @Override
    public ReadableBlock is(ReadableBlock pac) {
        if (pac.length() < 1L) {
            return null;
        }
        byte[] d = new byte[this.data.length];
        int dlsize = pac.read(d);
        if (dlsize == this.data.length && Arrays.equals(this.data, d)) {
            return pac.sub(pac.backLength() - (long)this.data.length, (long)this.data.length);
        }
        pac.back((long)dlsize);
        return null;
    }

    public int ch() {
        ByteBlock src = new ByteBlock(this.data);
        int ch = CodePoint.utf8((ReadableBlock)src);
        return src.length() == 0L ? ch : -1;
    }

    @Override
    public String toJava() {
        StringBuilder src = new StringBuilder("ABNF.bin(");
        if (this.data.length == 1) {
            src.append(this.toJavaCh(this.data[0]));
        } else {
            src.append("new byte[] {");
            boolean st = true;
            for (byte d : this.data) {
                if (st) {
                    st = false;
                } else {
                    src.append(",");
                }
                src.append(this.toJavaCh(d));
            }
            src.append("}");
        }
        src.append(")");
        return src.toString();
    }
}

