/*
 * Decompiled with CFR 0.152.
 */
package net.siisise.abnf;

import java.util.ArrayList;
import java.util.List;
import net.siisise.abnf.ABNF;
import net.siisise.abnf.ABNFbin;
import net.siisise.abnf.ABNFor;
import net.siisise.abnf.ABNFor1;
import net.siisise.abnf.IsABNF;
import net.siisise.block.ReadableBlock;
import net.siisise.bnf.BNF;
import net.siisise.bnf.BNFReg;
import net.siisise.lang.CodePoint;

public class ABNFmap
extends IsABNF {
    private final List<Integer> map = new ArrayList<Integer>();

    public ABNFmap() {
        this.name = "()";
    }

    public ABNFmap(String val) {
        ReadableBlock pac = ReadableBlock.wrap((String)val);
        StringBuilder n = new StringBuilder();
        n.append("( ");
        while (pac.size() > 0) {
            int ch;
            if (n.length() > 2) {
                n.append(" / ");
            }
            if (this.map.contains(ch = CodePoint.utf8((ReadableBlock)pac))) continue;
            this.map.add(ch);
            if (ch >= 32 && ch <= 126 && ch != 34) {
                n.append('\"');
                n.append(ch);
                n.append('\"');
                continue;
            }
            n.append(this.uhex(ch));
        }
        n.append(" )");
        this.name = n.toString();
    }

    @Override
    public ReadableBlock is(ReadableBlock pac) {
        if (pac.length() == 0L) {
            return null;
        }
        int of = pac.backSize();
        int ch = CodePoint.utf8((ReadableBlock)pac);
        if (ch < 0) {
            return null;
        }
        byte[] bin8 = CodePoint.utf8((int)ch);
        if (this.map.contains(ch)) {
            return ReadableBlock.wrap((byte[])bin8);
        }
        pac.seek((long)of);
        return null;
    }

    @Override
    public ABNF copy(BNFReg<ABNF> reg) {
        ABNFmap nm = new ABNFmap();
        nm.map.addAll(this.map);
        return nm;
    }

    @Override
    public ABNF or(BNF ... abnf) {
        ArrayList<Integer> tmap = new ArrayList<Integer>();
        ArrayList<BNF> xabnf = new ArrayList<BNF>();
        for (BNF a : abnf) {
            int ach;
            if (a instanceof ABNFbin && (ach = ((ABNFbin)a).ch()) >= 0) {
                if (this.map.contains(ach)) continue;
                tmap.add(ach);
                continue;
            }
            xabnf.add(a);
        }
        if (!tmap.isEmpty()) {
            ABNFmap nm = new ABNFmap();
            nm.map.addAll(this.map);
            nm.map.addAll(tmap);
            if (xabnf.isEmpty()) {
                return nm;
            }
            xabnf.add(nm);
            return new ABNFor(xabnf.toArray(new BNF[0]));
        }
        return super.or(abnf);
    }

    @Override
    public ABNF or1(BNF ... abnf) {
        ArrayList<Integer> tmap = new ArrayList<Integer>();
        ArrayList<BNF> xabnf = new ArrayList<BNF>();
        for (BNF a : abnf) {
            int ach;
            if (a instanceof ABNFbin && (ach = ((ABNFbin)a).ch()) >= 0) {
                if (this.map.contains(ach)) continue;
                tmap.add(ach);
                continue;
            }
            xabnf.add(a);
        }
        if (!tmap.isEmpty()) {
            ABNFmap nm = new ABNFmap();
            nm.map.addAll(this.map);
            nm.map.addAll(tmap);
            if (xabnf.isEmpty()) {
                return nm;
            }
            xabnf.add(0, nm);
            return new ABNFor1(xabnf.toArray(new BNF[0]));
        }
        return super.or1(abnf);
    }

    @Override
    public String toJava() {
        StringBuilder sb = new StringBuilder();
        sb.append("ABNF.binlist(\"");
        block9: for (Integer ch : this.map) {
            switch (ch) {
                case 8: {
                    sb.append("\\b");
                    continue block9;
                }
                case 9: {
                    sb.append("\\t");
                    continue block9;
                }
                case 10: {
                    sb.append("\\n");
                    continue block9;
                }
                case 12: {
                    sb.append("\\f");
                    continue block9;
                }
                case 13: {
                    sb.append("\\r");
                    continue block9;
                }
                case 34: {
                    sb.append("\\\"");
                    continue block9;
                }
                case 92: {
                    sb.append("\\\\");
                    continue block9;
                }
            }
            sb.appendCodePoint(ch);
        }
        sb.append("\")");
        return sb.toString();
    }
}

