/*
 * Decompiled with CFR 0.152.
 */
package net.siisise.abnf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.siisise.abnf.ABNF;
import net.siisise.abnf.ABNFtext;
import net.siisise.abnf.FindABNF;
import net.siisise.block.ByteBlock;
import net.siisise.block.ReadableBlock;
import net.siisise.bnf.BNF;
import net.siisise.bnf.BNFReg;
import net.siisise.bnf.parser.BNFParser;
import net.siisise.lang.CodePoint;

public class ABNFor
extends FindABNF {
    protected BNF[] list;

    public ABNFor(BNF ... abnfs) {
        this.list = abnfs;
        this.name = ABNFor.toName(abnfs);
    }

    ABNFor(String n, BNF ... abnfs) {
        this.name = n;
        this.list = abnfs;
    }

    @Deprecated
    public ABNFor(String chlist) {
        this(null, chlist);
    }

    public ABNFor(String name, String chlist) {
        ReadableBlock src = ReadableBlock.wrap((String)chlist);
        ArrayList<ABNFtext> abnfs = new ArrayList<ABNFtext>();
        while (src.length() > 0L) {
            abnfs.add(new ABNFtext(CodePoint.utf8((ReadableBlock)src)));
        }
        this.list = abnfs.toArray(new ABNF[abnfs.size()]);
        this.name = name == null ? ABNFor.toName(this.list) : name;
    }

    static String toName(BNF[] abnfs) {
        StringBuilder sb = new StringBuilder();
        sb.append("( ");
        for (BNF v : abnfs) {
            String n = v.getName();
            if (v instanceof ABNFor && n.startsWith("( ") && n.endsWith(" )")) {
                n = n.substring(2, n.length() - 2);
                sb.append(n);
            } else {
                sb.append(v.getName());
            }
            sb.append(" / ");
        }
        sb.delete(sb.length() - 3, sb.length());
        sb.append(" )");
        return sb.toString();
    }

    @Override
    public ABNFor copy(BNFReg<ABNF> reg) {
        BNF[] l = new BNF[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            l[i] = this.list[i].copy(reg);
        }
        return new ABNFor(this.name, l);
    }

    public void add(ABNF ... val) {
        BNF[] n = new ABNF[this.list.length + val.length];
        System.arraycopy(this.list, 0, n, 0, this.list.length);
        System.arraycopy(val, 0, n, this.list.length, val.length);
        this.name = ABNFor.toName(n);
        this.list = n;
    }

    @Override
    public <X> BNF.Match<X> buildFind(ReadableBlock pac, Object ns, BNFParser<? extends X> ... parsers) {
        long bp;
        if (pac instanceof ByteBlock) {
            return this.byteFind((ByteBlock)pac, ns, parsers);
        }
        BNF.Match<? extends X> ret = null;
        long o = bp = pac.backLength();
        for (BNF sub : this.list) {
            BNF.Match<? extends X> subret = sub.find(pac, ns, parsers);
            if (subret == null) continue;
            long len = subret.sub.length();
            if (ret == null || ret.sub.length() < len) {
                ret = subret;
                o = bp + len;
            }
            pac.seek(bp);
        }
        if (ret != null) {
            pac.seek(o);
        }
        return ret;
    }

    <X> BNF.Match<X> byteFind(ByteBlock src, Object ns, BNFParser<? extends X> ... parsers) {
        long bp = src.backLength();
        long sl = src.length();
        List<BNF> bnfList = Arrays.asList(this.list);
        List sub = bnfList.parallelStream().map(b -> b.find((ReadableBlock)src.sub(bp, sl), ns, parsers)).filter(x -> x != null).collect(Collectors.toList());
        if (sub.isEmpty()) {
            return null;
        }
        BNF.Match ret = (BNF.Match)sub.stream().max((a, b) -> (int)(a.sub.length() - b.sub.length())).get();
        ret.st = bp;
        src.skip(ret.sub.length());
        return ret;
    }

    @Override
    public String toJava() {
        StringBuilder src = new StringBuilder();
        src.append(this.list[0].toJava());
        if (this.list.length > 1) {
            src.append(".or(");
            for (int i = 1; i < this.list.length - 1; ++i) {
                src.append(this.list[i].toJava());
                src.append(",");
            }
            src.append(this.list[this.list.length - 1].toJava());
            src.append(")");
        }
        return src.toString();
    }
}

