/*
 * Decompiled with CFR 0.152.
 */
package net.siisise.abnf;

import net.siisise.abnf.ABNF;
import net.siisise.abnf.IsABNF;
import net.siisise.block.ReadableBlock;
import net.siisise.bnf.BNFReg;
import net.siisise.lang.CodePoint;

public class ABNFrange
extends IsABNF {
    private final int min;
    private final int max;

    public ABNFrange(int min, int max) {
        this.min = min;
        this.max = max;
        this.name = this.uhex(min) + "-" + this.uhex(max).substring(2);
    }

    @Override
    public ABNFrange copy(BNFReg<ABNF> reg) {
        return new ABNFrange(this.min, this.max);
    }

    @Override
    public ReadableBlock is(ReadableBlock rb) {
        if (rb.length() == 0L) {
            return null;
        }
        long of = rb.backLength();
        int ch = CodePoint.utf8((ReadableBlock)rb);
        if (ch < 0) {
            return null;
        }
        if (ch >= this.min && ch <= this.max) {
            return rb.sub(of, rb.backLength() - of);
        }
        rb.seek(of);
        return null;
    }

    public ABNF or(int min, int max) {
        return this.or1(new ABNFrange(min, max));
    }

    public ABNF or1(int min, int max) {
        return this.or1(new ABNFrange(min, max));
    }

    @Override
    public String toJava() {
        return "ABNF.range(0x" + Integer.toHexString(this.min) + ", 0x" + Integer.toHexString(this.max) + ")";
    }
}

