/*
 * Decompiled with CFR 0.152.
 */
package net.siisise.abnf;

import net.siisise.abnf.ABNF;
import net.siisise.abnf.IsABNF;
import net.siisise.block.ReadableBlock;
import net.siisise.bnf.BNFReg;

public class ABNFtext
extends IsABNF {
    private final String text;
    private final byte[] utf8;

    ABNFtext(int ch) {
        char[] chars = Character.toChars(ch);
        this.text = String.valueOf(chars);
        this.name = ch < 127 && ch >= 32 && ch != 34 ? "\"" + this.text + "\"" : this.uhex(ch);
        this.utf8 = this.text.getBytes(UTF8);
    }

    ABNFtext(String text) {
        this.text = text;
        this.name = "\"" + text + "\"";
        this.utf8 = text.getBytes(UTF8);
    }

    @Override
    public String toJava() {
        return "ABNF.text(" + this.name + ")";
    }

    @Override
    public ABNFtext copy(BNFReg<ABNF> reg) {
        return new ABNFtext(this.text);
    }

    @Override
    public ReadableBlock is(ReadableBlock pac) {
        if (pac.length() < 1L) {
            return null;
        }
        byte[] d = new byte[this.utf8.length];
        int size = pac.read(d);
        if (size < this.utf8.length) {
            pac.back((long)size);
            return null;
        }
        String u = new String(d, UTF8);
        if (u.equalsIgnoreCase(this.text)) {
            return ReadableBlock.wrap((byte[])d);
        }
        pac.back((long)size);
        return null;
    }
}

