/*
 * Decompiled with CFR 0.152.
 */
package net.siisise.abnf.parser5234;

import net.siisise.abnf.ABNF;
import net.siisise.block.ReadableBlock;
import net.siisise.bnf.BNF;
import net.siisise.bnf.parser.BNFBaseParser;
import net.siisise.io.Input;
import net.siisise.io.PacketA;
import net.siisise.lang.CodePoint;

class NumSub
extends BNFBaseParser<ABNF> {
    private static final ABNF hf = ABNF.bin(45);
    private static final ABNF dot = ABNF.bin(46);
    private final BNF nrule;
    private final int dig;
    private final char a;
    private final char b;

    NumSub(BNF rule, BNF numrule, int dig, char a, char b) {
        super(rule);
        this.nrule = numrule.ix();
        this.dig = dig;
        this.a = a;
        this.b = b;
    }

    @Override
    public ABNF parse(ReadableBlock pac) {
        int c = pac.read();
        if (c != this.a && c != this.b) {
            pac.back(1L);
            return null;
        }
        long nl1 = pac.length();
        int v = this.num(pac);
        boolean oct1 = this.isBin(v, nl1 -= pac.length());
        ReadableBlock r = hf.is(pac);
        if (r != null) {
            long nl2 = pac.length();
            int max = this.num(pac);
            if (oct1 && this.isBin(max, nl2 -= pac.length())) {
                return ABNF.binRange(v, max);
            }
            return ABNF.range(v, max);
        }
        r = dot.is(pac);
        if (r == null) {
            if (oct1) {
                return ABNF.bin(new byte[]{(byte)v});
            }
            return ABNF.bin(v);
        }
        PacketA data = new PacketA();
        if (oct1) {
            data.write(new byte[]{(byte)v});
        } else {
            data.write(CodePoint.utf8((int)v));
        }
        do {
            long nlx = pac.length();
            int c2 = this.num(pac);
            if (this.isBin(c2, nlx -= pac.length())) {
                data.write(c2);
                continue;
            }
            data.write(CodePoint.utf8((int)c2));
        } while ((r = dot.is(pac)) != null);
        return ABNF.bin(data.toByteArray());
    }

    private boolean isBin(int v, long nl) {
        return this.dig == 2 && nl == 8L || this.dig == 16 && nl == 2L || this.dig == 10 && nl < 4L && v < 256;
    }

    private int num(ReadableBlock pac) {
        ReadableBlock num = this.nrule.is(pac);
        return Integer.parseInt(NumSub.str((Input)num), this.dig);
    }
}

