/*
 * Decompiled with CFR 0.152.
 */
package net.siisise.bnf;

import net.siisise.block.ReadableBlock;
import net.siisise.bnf.BNF;
import net.siisise.bnf.BNFmn;
import net.siisise.bnf.BNFor;
import net.siisise.bnf.BNFor1;
import net.siisise.bnf.BNFpl;
import net.siisise.bnf.BNFplm;
import net.siisise.bnf.BNFplu;
import net.siisise.bnf.BNFrule;
import net.siisise.bnf.BNFx;
import net.siisise.bnf.parser.BNFParser;
import net.siisise.io.FrontPacket;
import net.siisise.io.Input;
import net.siisise.io.Packet;
import net.siisise.io.PacketA;

public abstract class AbstractBNF<B extends BNF>
implements BNF<B> {
    protected String name;

    @Override
    public String getName() {
        if (this.name == null) {
            return "???";
        }
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public B name(String name) {
        return (B)new BNFrule<AbstractBNF>(name, this);
    }

    protected <X> BNFParser<? extends X> matchParser(BNFParser<? extends X>[] parsers) {
        for (BNFParser<X> bNFParser : parsers) {
            if (!this.name.equals(bNFParser.getBNF().getName())) continue;
            return bNFParser;
        }
        return null;
    }

    @Override
    public boolean is(String val) {
        return this.is(AbstractBNF.rb(val)) != null;
    }

    @Override
    public boolean is(String val, Object ns) {
        return this.is(AbstractBNF.rb(val), ns) != null;
    }

    @Override
    public Packet is(FrontPacket pac) {
        ReadableBlock res = this.is(AbstractBNF.rb(pac));
        return res != null ? AbstractBNF.pac(res) : null;
    }

    @Override
    public Packet is(FrontPacket pac, Object ns) {
        ReadableBlock res = this.is(AbstractBNF.rb(pac), ns);
        return res != null ? AbstractBNF.pac(res) : null;
    }

    @Override
    public <X> BNF.Match<X> find(FrontPacket pac, BNFParser<? extends X> ... parsers) {
        return this.find(AbstractBNF.rb(pac), (Object)null, parsers);
    }

    @Override
    public <X> BNF.Match<X> find(ReadableBlock pac, BNFParser<? extends X> ... parsers) {
        return this.find(pac, (Object)null, parsers);
    }

    @Override
    public <X> BNF.Match<X> find(FrontPacket pac, Object ns, BNFParser<? extends X> ... parsers) {
        return this.find(AbstractBNF.rb(pac), ns, parsers);
    }

    @Override
    public boolean eq(ReadableBlock src) {
        ReadableBlock r = this.is(src);
        if (r != null && src.length() == 0L) {
            return true;
        }
        if (r != null) {
            src.back(r.length());
        }
        return false;
    }

    @Override
    public boolean eq(FrontPacket src) {
        return this.eq(AbstractBNF.rb(src));
    }

    @Override
    public boolean eq(String src) {
        return this.eq(AbstractBNF.rb(src));
    }

    @Override
    public B pl(BNF ... val) {
        if (val.length == 0) {
            return (B)this;
        }
        BNF[] list = new BNF[val.length + 1];
        list[0] = this;
        System.arraycopy(val, 0, list, 1, val.length);
        return (B)new BNFpl(list);
    }

    @Override
    public B plm(BNF ... val) {
        if (val.length == 0) {
            return (B)this;
        }
        BNF[] list = new BNF[val.length + 1];
        list[0] = this;
        System.arraycopy(val, 0, list, 1, val.length);
        return (B)new BNFplm(list);
    }

    @Override
    public B plu(BNF ... vals) {
        if (vals.length == 0) {
            return (B)this;
        }
        BNF[] list = new BNF[vals.length + 1];
        list[0] = this;
        System.arraycopy(vals, 0, list, 1, vals.length);
        return (B)new BNFplu(list);
    }

    @Override
    public B or(BNF ... vals) {
        BNF[] list = new BNF[vals.length + 1];
        list[0] = this;
        System.arraycopy(vals, 0, list, 1, vals.length);
        return (B)new BNFor(list);
    }

    @Override
    public B or1(BNF ... vals) {
        BNF[] list = new BNF[vals.length + 1];
        list[0] = this;
        System.arraycopy(vals, 0, list, 1, vals.length);
        return (B)new BNFor1(list);
    }

    @Override
    public B x(int min, int max) {
        return (B)new BNFx(min, max, this);
    }

    @Override
    public B x(int num) {
        return this.x(num, num);
    }

    @Override
    public B x() {
        return this.x(0, -1);
    }

    @Override
    public B ix() {
        return this.x(1, -1);
    }

    @Override
    public B c() {
        return this.x(0, 1);
    }

    @Override
    public B mn(BNF val) {
        return (B)new BNFmn(this, val);
    }

    public static FrontPacket pac(String str) {
        PacketA pac = new PacketA();
        pac.dwrite(str.getBytes(UTF8));
        return pac;
    }

    public static final ReadableBlock rb(String str) {
        return ReadableBlock.wrap((String)str);
    }

    public static final ReadableBlock rb(FrontPacket p) {
        return ReadableBlock.wrap((FrontPacket)p);
    }

    public static final Packet pac(ReadableBlock rb) {
        PacketA pac = new PacketA();
        pac.write((Input)rb);
        return pac;
    }

    public static String str(Input pac) {
        return new String(pac.toByteArray(), UTF8);
    }

    public static String strd(FrontPacket pac) {
        byte[] data = pac.toByteArray();
        String s = new String(data, UTF8);
        pac.backWrite(data);
        return s;
    }

    public static String strd(ReadableBlock pac) {
        byte[] data = pac.toByteArray();
        String s = new String(data, UTF8);
        pac.back((long)data.length);
        return s;
    }

    protected <X> BNF.Match<X> subBuild(BNF.Match<X> cret, Object ns, BNFParser<? extends X> parser) {
        if (parser != null) {
            cret.subs.clear();
            long o = cret.sub.backLength();
            cret.add(this.name, parser.parse(cret.sub, ns));
            cret.sub.seek(o);
        }
        return cret;
    }

    protected static <X> void mix(BNF.Match<X> ret, BNF.Match<X> sub) {
        sub.subs.forEach((key, vlist) -> vlist.forEach(v -> ret.add((String)key, (Object)v)));
    }

    protected String uhex(int ch) {
        if (ch < 128) {
            return "%x" + Integer.toHexString(256 + ch).substring(1);
        }
        if (ch < 65536) {
            return "%x" + Integer.toHexString(65536 + ch).substring(1);
        }
        return "%x" + Integer.toHexString(0x1000000 + ch).substring(1);
    }

    protected String toJavaCh(byte ch) {
        switch (ch) {
            case 8: {
                return "'\\b'";
            }
            case 9: {
                return "'\\t'";
            }
            case 10: {
                return "'\\n'";
            }
            case 13: {
                return "'\\r'";
            }
            case 12: {
                return "'\\f'";
            }
            case 39: {
                return "'\\''";
            }
            case 34: {
                return "'\\\"'";
            }
            case 92: {
                return "'\\\\'";
            }
        }
        StringBuilder s = new StringBuilder();
        if (ch >= 32 && ch <= 126) {
            s.append('\'');
            s.append((char)ch);
            s.append('\'');
        } else {
            s.append("0x");
            String hex = "0" + Integer.toHexString(ch & 0xFF).toUpperCase();
            s.append(hex.substring(hex.length() - 2));
        }
        return s.toString();
    }
}

