/*
 * Decompiled with CFR 0.152.
 */
package net.siisise.bnf;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.siisise.block.ReadableBlock;
import net.siisise.bnf.BNFReg;
import net.siisise.bnf.BNFbin;
import net.siisise.bnf.BNFor1;
import net.siisise.bnf.BNFrange;
import net.siisise.bnf.BNFtext;
import net.siisise.bnf.parser.BNFParser;
import net.siisise.io.FrontPacket;
import net.siisise.io.Packet;
import net.siisise.lang.CodePoint;

public interface BNF<B extends BNF> {
    public static final Charset UTF8 = StandardCharsets.UTF_8;

    public B name(String var1);

    public String getName();

    public Packet is(FrontPacket var1, Object var2);

    public ReadableBlock is(ReadableBlock var1, Object var2);

    public Packet is(FrontPacket var1);

    public ReadableBlock is(ReadableBlock var1);

    public boolean is(String var1, Object var2);

    public boolean is(String var1);

    public <X> Match<X> find(FrontPacket var1, Object var2, BNFParser<? extends X> ... var3);

    public <X> Match<X> find(ReadableBlock var1, Object var2, BNFParser<? extends X> ... var3);

    public <X> Match<X> find(FrontPacket var1, BNFParser<? extends X> ... var2);

    public <X> Match<X> find(ReadableBlock var1, BNFParser<? extends X> ... var2);

    public boolean eq(ReadableBlock var1);

    public boolean eq(FrontPacket var1);

    public boolean eq(String var1);

    public B pl(BNF ... var1);

    public B plm(BNF ... var1);

    public B plu(BNF ... var1);

    public B or(BNF ... var1);

    public B or1(BNF ... var1);

    public B x(int var1, int var2);

    public B x(int var1);

    public B x();

    public B ix();

    public B c();

    @Deprecated
    public B mn(BNF var1);

    public B copy(BNFReg<B> var1);

    public String toJava();

    public static BNFtext text(char ch) {
        return new BNFtext(ch);
    }

    public static BNFtext text(String txt) {
        return new BNFtext(txt);
    }

    public static BNF list(String chlist) {
        ReadableBlock src = ReadableBlock.wrap((String)chlist);
        ArrayList<BNFtext> abnfs = new ArrayList<BNFtext>();
        while (src.length() > 0L) {
            int c = CodePoint.utf8((ReadableBlock)src);
            abnfs.add(new BNFtext(c));
        }
        return new BNFor1(abnfs.toArray(new BNF[abnfs.size()]));
    }

    public static BNFbin bin(int ch) {
        return new BNFbin(ch);
    }

    public static BNFbin bin(String str) {
        return new BNFbin(str);
    }

    public static BNFbin bin(byte b) {
        return new BNFbin(new byte[]{b});
    }

    public static BNFbin bin(byte[] src) {
        return new BNFbin(src);
    }

    public static BNFrange range(int min, int max) {
        return new BNFrange(min, max);
    }

    public static class Match<X> {
        public ReadableBlock sub;
        public long st;
        public final Map<String, List<X>> subs = new HashMap<String, List<X>>();

        public Match(ReadableBlock rb) {
            this.st = rb.backLength();
        }

        public Match<X> end(ReadableBlock rb) {
            this.sub = rb.sub(this.st, rb.backLength() - this.st);
            return this;
        }

        public void add(String name, X r) {
            List<X> l = this.subs.get(name);
            if (l == null) {
                l = new ArrayList<X>();
                this.subs.put(name, l);
            }
            l.add(r);
        }

        public Set<String> keySet() {
            return this.subs.keySet();
        }

        public List<X> get(String name) {
            return this.subs.get(name);
        }

        public List<X> get(BNF bnf) {
            return this.get(bnf.getName());
        }
    }
}

