/*
 * Decompiled with CFR 0.152.
 */
package net.siisise.bnf;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.siisise.abnf.ABNFrule;
import net.siisise.block.ReadableBlock;
import net.siisise.bnf.AbstractBNF;
import net.siisise.bnf.BNF;
import net.siisise.bnf.BNFCC;
import net.siisise.bnf.BNFrule;
import net.siisise.bnf.parser.BNFPacketParser;
import net.siisise.bnf.parser.BNFParser;
import net.siisise.io.FrontPacket;

public class BNFReg<B extends BNF> {
    protected final Map<String, B> reg = new HashMap<String, B>();
    protected final Map<String, Class<? extends BNFParser>> CL = new HashMap<String, Class<? extends BNFParser>>();
    protected BNFCC<B> bnfReg;
    protected BNF rn;

    public BNFReg(BNFReg<B> up, BNFCC<B> bnfParser) {
        if (up != null) {
            up.CL.forEach((key, val) -> this.CL.put((String)key, (Class<? extends BNFParser>)val));
            up.reg.forEach((key, val) -> this.reg.put((String)key, val.copy(this)));
        }
        this.bnfReg = bnfParser;
        this.rn = bnfParser == null ? null : (BNF)bnfParser.reg.get(bnfParser.rulename);
    }

    public B ref(String rulename) {
        return (B)new BNFRef(rulename);
    }

    public BNF href(String rulename) {
        BNF bnf = (BNF)this.reg.get(rulename);
        if (bnf == null) {
            bnf = new BNFRef(rulename);
        }
        return bnf;
    }

    public <T> T parse(String rulename, String src) {
        return this.parser(rulename).parse(src);
    }

    public <T> T parse(String rulename, String src, Object ns) {
        return this.parser(rulename).parse(src, ns);
    }

    public <T> T parse(String rulename, byte[] src) {
        return this.parser(rulename).parse(ReadableBlock.wrap((byte[])src));
    }

    public <T> T parse(String rulename, byte[] src, Object ns) {
        return this.parser(rulename).parse(ReadableBlock.wrap((byte[])src), ns);
    }

    public <T> T parse(String rulename, FrontPacket pac) {
        return this.parser(rulename).parse(pac);
    }

    public <T> T parse(String rulename, FrontPacket pac, Object ns) {
        return this.parser(rulename).parse(pac, ns);
    }

    public <T> T parse(String rulename, ReadableBlock pac) {
        return this.parser(rulename).parse(pac);
    }

    public <T> T parse(String rulename, ReadableBlock pac, Object ns) {
        return this.parser(rulename).parse(pac, ns);
    }

    public <T> BNFParser<T> parser(String rulename) {
        BNF rule = (BNF)this.reg.get(rulename);
        Class<? extends BNFParser> rulep = this.CL.get(rulename);
        if (rulep == null) {
            return new BNFPacketParser(rule);
        }
        try {
            Constructor<? extends BNFParser> cnst = rulep.getConstructor(BNF.class, BNFReg.class);
            return cnst.newInstance(rule, this);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new UnsupportedOperationException(ex);
        }
    }

    public <E extends B> E rule(String rulename, E elements) {
        if (this.bnfReg != null && !this.bnfReg.isRulename(rulename)) {
            System.err.println("BNF:" + rulename + " BNF\u306e\u540d\u79f0\u306b\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        if (!rulename.equals(elements.getName())) {
            elements = elements.name(rulename);
        }
        this.reg.put(rulename, elements);
        return elements;
    }

    public <E extends B> E rule(String rulename, Class<? extends BNFParser> parser, E elements) {
        elements = this.rule(rulename, elements);
        this.CL.put(rulename, parser);
        return elements;
    }

    public B rule(String rulename, String elements) {
        return this.rule(rulename, this.elements(elements));
    }

    public B rule(String rulename, Class<? extends BNFParser> parser, String elements) {
        return this.rule(rulename, parser, this.elements(elements));
    }

    public B elements(String elements) {
        return (B)((BNF)this.bnfReg.parse(this.bnfReg.elements, elements, (Object)this));
    }

    public B rule(String rule) {
        BNF bnf = (BNF)this.bnfReg.parse(this.bnfReg.rule, rule + "\r\n", (Object)this);
        return (B)this.rule(bnf.getName(), bnf);
    }

    public BNF.Match find(FrontPacket pac, String rulename, String ... subrulenames) {
        return this.find(ReadableBlock.wrap((FrontPacket)pac), rulename, subrulenames);
    }

    public BNF.Match find(ReadableBlock rb, String rulename, String ... subrulenames) {
        BNF rule = this.href(rulename);
        BNFParser[] cll = new BNFParser[subrulenames.length];
        for (int i = 0; i < subrulenames.length; ++i) {
            cll[i] = this.parser(subrulenames[i]);
        }
        return rule.find(rb, cll);
    }

    String javaLine(String ruleName, String regName, BNFrule rule) {
        StringBuilder src = new StringBuilder();
        src.append("\r\n    static final BNF ");
        src.append(ruleName).append(" = ").append(regName);
        src.append(rule.toJavaLine());
        src.append(";");
        return src.toString();
    }

    String javaLine(String ruleName, String regName, ABNFrule rule) {
        StringBuilder src = new StringBuilder();
        src.append("\r\n    static final BNF ");
        src.append(ruleName).append(" = ").append(regName);
        src.append(rule.toJavaLine());
        src.append(";");
        return src.toString();
    }

    public String toJava(String regName) {
        StringBuilder src = new StringBuilder();
        src.append("class Example {");
        src.append("\r\n    static BNFReg ").append(regName).append(" = new BNFReg();");
        src.append("\r\n");
        for (String ruleName : this.reg.keySet()) {
            AbstractBNF bnf;
            BNF b = (BNF)this.reg.get(ruleName);
            if (b instanceof BNFrule) {
                bnf = (BNFrule)b;
                src.append(this.javaLine(ruleName, regName, (BNFrule)bnf));
                continue;
            }
            if (!(b instanceof ABNFrule)) continue;
            bnf = (ABNFrule)b;
            src.append(this.javaLine(ruleName, regName, (ABNFrule)bnf));
        }
        src.append("\r\n}");
        return src.toString();
    }

    public class BNFRef
    extends AbstractBNF<B> {
        BNFRef(String rulename) {
            this.name = rulename;
        }

        @Override
        public B copy(BNFReg<B> reg) {
            return reg.ref(this.name);
        }

        @Override
        public ReadableBlock is(ReadableBlock src, Object ns) {
            return ((BNF)BNFReg.this.reg.get(this.name)).is(src, ns);
        }

        @Override
        public ReadableBlock is(ReadableBlock src) {
            return ((BNF)BNFReg.this.reg.get(this.name)).is(src);
        }

        @Override
        public <X> BNF.Match<X> find(ReadableBlock pac, Object ns, BNFParser<? extends X> ... parsers) {
            return ((BNF)BNFReg.this.reg.get(this.name)).find(pac, ns, parsers);
        }

        @Override
        public String toJava() {
            return this.name;
        }
    }
}

