/*
 * Decompiled with CFR 0.152.
 */
package net.siisise.bnf;

import java.util.Arrays;
import net.siisise.block.ReadableBlock;
import net.siisise.bnf.BNF;
import net.siisise.bnf.BNFReg;
import net.siisise.bnf.IsBNF;
import net.siisise.lang.CodePoint;

public class BNFbin
extends IsBNF<BNF> {
    private final byte[] data;

    BNFbin(int ch) {
        this.name = ch >= 32 && (ch != 34 && ch < 65 || ch > 90 && ch < 97 || ch > 122 && ch < 127) ? "\"" + (char)ch + "\"" : this.uhex(ch);
        this.data = CodePoint.utf8((int)ch);
    }

    BNFbin(String str) {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.uhex(str.charAt(0)));
        for (int i = 1; i < str.length(); ++i) {
            sb.append(".");
            sb.append(this.uhex(str.charAt(i)).substring(2));
        }
        this.name = sb.toString();
        this.data = str.getBytes(UTF8);
    }

    BNFbin(byte[] src) {
        this.data = src;
        this.name = "\u30d0\u30a4\u30c8\u5217(" + src.length + ")";
    }

    @Override
    public BNFbin copy(BNFReg<BNF> reg) {
        return new BNFbin(new String(this.data, UTF8));
    }

    @Override
    public ReadableBlock is(ReadableBlock pac) {
        if (pac.length() < 1L) {
            return null;
        }
        byte[] d = new byte[this.data.length];
        int dlsize = pac.read(d);
        if (dlsize == this.data.length && Arrays.equals(this.data, d)) {
            return pac.sub(pac.backLength() - (long)this.data.length, (long)this.data.length);
        }
        pac.back((long)dlsize);
        return null;
    }

    public int ch() {
        ReadableBlock src = ReadableBlock.wrap((byte[])this.data);
        int ch = CodePoint.utf8((ReadableBlock)src);
        return src.length() == 0L ? ch : -1;
    }

    @Override
    public String toJava() {
        StringBuilder src = new StringBuilder("ABNF.bin(");
        src.append(this.name);
        src.append(")");
        return src.toString();
    }
}

