/*
 * Decompiled with CFR 0.152.
 */
package net.siisise.bnf;

import java.util.ArrayList;
import java.util.List;
import net.siisise.block.ReadableBlock;
import net.siisise.bnf.BNF;
import net.siisise.bnf.BNFReg;
import net.siisise.bnf.IsBNF;
import net.siisise.lang.CodePoint;

public class BNFmap
extends IsBNF<BNF> {
    private final List<Integer> map = new ArrayList<Integer>();

    @Override
    public ReadableBlock is(ReadableBlock pac) {
        if (pac.length() == 0L) {
            return null;
        }
        int of = pac.backSize();
        int ch = CodePoint.utf8((ReadableBlock)pac);
        if (ch < 0) {
            return null;
        }
        byte[] bin8 = CodePoint.utf8((int)ch);
        if (this.map.contains(ch)) {
            return ReadableBlock.wrap((byte[])bin8);
        }
        pac.seek((long)of);
        return null;
    }

    @Override
    public BNF copy(BNFReg<BNF> reg) {
        BNFmap nm = new BNFmap();
        nm.map.addAll(this.map);
        return nm;
    }

    @Override
    public String toJava() {
        StringBuilder sb = new StringBuilder();
        sb.append("BNF.binlist(\"");
        block9: for (Integer ch : this.map) {
            char[] cp;
            switch (ch) {
                case 8: {
                    sb.append("\\b");
                    continue block9;
                }
                case 9: {
                    sb.append("\\t");
                    continue block9;
                }
                case 10: {
                    sb.append("\\n");
                    continue block9;
                }
                case 12: {
                    sb.append("\\f");
                    continue block9;
                }
                case 13: {
                    sb.append("\\r");
                    continue block9;
                }
                case 34: {
                    sb.append("\\\"");
                    continue block9;
                }
                case 92: {
                    sb.append("\\\\");
                    continue block9;
                }
            }
            for (char c : cp = Character.toChars(ch)) {
                if (c >= ' ' && c != '\u007f') continue;
                sb.append("\\u");
                String hex = "000" + Integer.toHexString(ch);
                sb.append(hex.substring(hex.length() - 4));
            }
            sb.appendCodePoint(ch);
        }
        sb.append("\")");
        return sb.toString();
    }
}

