/*
 * Decompiled with CFR 0.152.
 */
package net.siisise.bnf;

import net.siisise.block.ReadableBlock;
import net.siisise.bnf.BNF;
import net.siisise.bnf.BNFReg;
import net.siisise.bnf.FindBNF;
import net.siisise.bnf.parser.BNFParser;

public class BNFor
extends FindBNF<BNF> {
    protected BNF[] list;

    public BNFor(BNF ... bnfs) {
        this.list = bnfs;
        this.name = BNFor.toName(bnfs);
    }

    public BNFor(String n, BNF ... bnfs) {
        this.name = n;
        this.list = bnfs;
    }

    static String toName(BNF[] abnfs) {
        StringBuilder sb = new StringBuilder();
        sb.append("( ");
        for (BNF v : abnfs) {
            String n = v.getName();
            if (v instanceof BNFor && n.startsWith("( ") && n.endsWith(" )")) {
                n = n.substring(2, n.length() - 2);
                sb.append(n);
            } else {
                sb.append(v.getName());
            }
            sb.append(" / ");
        }
        sb.delete(sb.length() - 3, sb.length());
        sb.append(" )");
        return sb.toString();
    }

    @Override
    protected <X> BNF.Match<X> buildFind(ReadableBlock pac, Object ns, BNFParser<? extends X> ... parsers) {
        for (BNF sub : this.list) {
            BNF.Match<? extends X> subret = sub.find(pac, ns, parsers);
            if (subret == null) continue;
            return subret;
        }
        return null;
    }

    @Override
    public BNF copy(BNFReg reg) {
        BNF[] l = new BNF[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            l[i] = this.list[i].copy(reg);
        }
        return new BNFor(this.name, l);
    }

    public void add(BNF ... val) {
        BNF[] n = new BNF[this.list.length + val.length];
        System.arraycopy(this.list, 0, n, 0, this.list.length);
        System.arraycopy(val, 0, n, this.list.length, val.length);
        this.name = BNFor.toName(n);
        this.list = n;
    }

    @Override
    public String toJava() {
        StringBuilder src = new StringBuilder();
        src.append(this.list[0].toJava());
        if (this.list.length > 1) {
            src.append(".or(");
            for (int i = 1; i < this.list.length - 1; ++i) {
                src.append(this.list[i].toJava());
                src.append(",");
            }
            src.append(this.list[this.list.length - 1].toJava());
            src.append(")");
        }
        return src.toString();
    }
}

