/*
 * Decompiled with CFR 0.152.
 */
package net.siisise.bnf;

import net.siisise.block.ReadableBlock;
import net.siisise.bnf.BNF;
import net.siisise.bnf.BNFReg;
import net.siisise.bnf.IsBNF;
import net.siisise.lang.CodePoint;

public class BNFrange
extends IsBNF<BNF> {
    private final int min;
    private final int max;

    public BNFrange(int min, int max) {
        this.min = min;
        this.max = max;
        this.name = this.uhex(min) + "-" + this.uhex(max).substring(2);
    }

    @Override
    public BNFrange copy(BNFReg<BNF> reg) {
        return new BNFrange(this.min, this.max);
    }

    @Override
    public ReadableBlock is(ReadableBlock rb) {
        if (rb.length() == 0L) {
            return null;
        }
        long of = rb.backLength();
        int ch = CodePoint.utf8((ReadableBlock)rb);
        if (ch < 0) {
            return null;
        }
        if (ch >= this.min && ch <= this.max) {
            return rb.sub(of, rb.backLength() - of);
        }
        rb.seek(of);
        return null;
    }

    @Override
    public String toJava() {
        return "BNF.range(0x" + Integer.toHexString(this.min) + ", 0x" + Integer.toHexString(this.max) + ")";
    }
}

