/*
 * Decompiled with CFR 0.152.
 */
package net.siisise.bnf;

import net.siisise.block.ReadableBlock;
import net.siisise.bnf.BNF;
import net.siisise.bnf.BNFReg;
import net.siisise.bnf.IsBNF;

public class BNFtext
extends IsBNF {
    private final String text;
    private final byte[] utf8;

    BNFtext(int ch) {
        char[] chars = Character.toChars(ch);
        this.text = String.valueOf(chars);
        this.name = ch < 127 && ch >= 32 && ch != 34 ? "\"" + this.text + "\"" : this.uhex(ch);
        this.utf8 = this.text.getBytes(UTF8);
    }

    BNFtext(String text) {
        this.text = text;
        this.name = "\"" + text + "\"";
        this.utf8 = text.getBytes(UTF8);
    }

    @Override
    public ReadableBlock is(ReadableBlock pac) {
        if (pac.length() < 1L) {
            return null;
        }
        byte[] d = new byte[this.utf8.length];
        int size = pac.read(d);
        if (size < this.utf8.length) {
            pac.back((long)size);
            return null;
        }
        String u = new String(d, UTF8);
        if (u.equalsIgnoreCase(this.text)) {
            return ReadableBlock.wrap((byte[])d);
        }
        pac.back((long)size);
        return null;
    }

    @Override
    public BNF copy(BNFReg reg) {
        return new BNFtext(this.text);
    }

    @Override
    public String toJava() {
        return "BNF.text(" + this.text + ")";
    }
}

