/*
 * Decompiled with CFR 0.152.
 */
package net.siisise.bnf.parser5234;

import net.siisise.bnf.BNF;
import net.siisise.bnf.BNFCC;
import net.siisise.bnf.BNFReg;
import net.siisise.bnf.parser.BNFStringParser;
import net.siisise.bnf.parser5234.Alternation;
import net.siisise.bnf.parser5234.CharVal;
import net.siisise.bnf.parser5234.Concatenation;
import net.siisise.bnf.parser5234.Element;
import net.siisise.bnf.parser5234.NumVal;
import net.siisise.bnf.parser5234.Option;
import net.siisise.bnf.parser5234.ProseVal;
import net.siisise.bnf.parser5234.Repetition;
import net.siisise.bnf.parser5234.Rule;
import net.siisise.bnf.parser5234.Rulelist;
import net.siisise.bnf.parser5234.Rulename;
import net.siisise.bnf.parser5234.SubAlternation;

public class ABNF5234 {
    public static final BNFReg<BNF> BASE = new BNFReg(null, null);
    public static final BNF ALPHA = BASE.rule("ALPHA", BNF.range(65, 90).or1(BNF.range(97, 122)));
    public static final BNF BIT = BASE.rule("BIT", BNF.bin(48).or1(BNF.bin(49)));
    public static final BNF CHAR = BASE.rule("CHAR", BNF.range(1, 127));
    public static final BNF CR = BASE.rule("CR", BNF.bin(13));
    public static final BNF LF = BASE.rule("LF", BNF.bin(10));
    public static final BNF CRLF = BASE.rule("CRLF", BNF.bin("\r\n"));
    public static final BNF CTL = BASE.rule("CTL", BNF.range(0, 31).or1(BNF.bin(127)));
    public static final BNF DIGIT = BASE.rule("DIGIT", BNF.range(48, 57));
    public static final BNF DQUOTE = BASE.rule("DQUOTE", BNF.bin(34));
    public static final BNF HEXDIG = BASE.rule("HEXDIG", DIGIT.or1(BNF.range(97, 102), BNF.range(65, 70)));
    public static final BNF HTAB = BASE.rule("HTAB", BNF.bin(9));
    public static final BNF OCTET = BASE.rule("OCTET", BNF.range(0, 255));
    public static final BNF SP = BASE.rule("SP", BNF.bin(32));
    public static final BNF VCHAR = BASE.rule("VCHAR", BNF.range(33, 126));
    public static final BNF WSP = BASE.rule("WSP", SP.or1(HTAB));
    public static final BNF LWSP = BASE.rule("LWSP", WSP.or1(new BNF[]{CRLF.pl(WSP)}).x());
    public static final BNFCC<BNF> REG = BNFCC.abnf(BASE, null);
    public static final BNF charVal = REG.rule("char-val", CharVal.class, DQUOTE.pl(new BNF[]{BNF.range(32, 33).or1(BNF.range(35, 126)).x(), DQUOTE}));
    public static final BNF binVal = REG.rule("bin-val", NumVal.BinVal.class, BNF.text('b').pl(new BNF[]{BIT.ix(), BNF.bin(46).pl(new BNF[]{BIT.ix()}).ix().or(new BNF[]{BNF.bin(45).pl(new BNF[]{BIT.ix()})}).c()}));
    public static final BNF decVal = REG.rule("dec-val", NumVal.DecVal.class, BNF.text('d').pl(new BNF[]{DIGIT.ix(), BNF.bin(46).pl(new BNF[]{DIGIT.ix()}).ix().or(new BNF[]{BNF.bin(45).pl(new BNF[]{DIGIT.ix()})}).c()}));
    public static final BNF hexVal = REG.rule("hex-val", NumVal.HexVal.class, BNF.text('x').pl(new BNF[]{HEXDIG.ix(), BNF.bin(46).pl(new BNF[]{HEXDIG.ix()}).ix().or(new BNF[]{BNF.bin(45).pl(new BNF[]{HEXDIG.ix()})}).c()}));
    public static final BNF proseVal = REG.rule("prose-val", ProseVal.class, BNF.text('<').pl(new BNF[]{BNF.range(32, 61).or1(BNF.range(63, 126)).x(), BNF.bin(62)}));
    public static final BNF numVal = REG.rule("num-val", NumVal.class, BNF.text('%').pl(new BNF[]{binVal.or1(decVal, hexVal)}));
    public static final BNF rulename = REG.rule("rulename", Rulename.class, ALPHA.pl(new BNF[]{ALPHA.or1(DIGIT, BNF.bin(45)).x()}));
    public static final BNF comment = REG.rule("comment", BNF.bin(59).pl(new BNF[]{WSP.or1(VCHAR).x(), CRLF}));
    public static final BNF repeat = REG.rule("repeat", BNFStringParser.class, DIGIT.x().pl(new BNF[]{BNF.bin(42), DIGIT.x()}).or1(new BNF[]{DIGIT.ix()}));
    public static final BNF repetition = REG.rule("repetition", Repetition.class, repeat.c().pl(new BNF[]{REG.ref("element")}));
    static final BNF cNl = REG.rule("c-nl", comment.or1(CRLF));
    static final BNF cWsp = REG.rule("c-wsp", WSP.or(new BNF[]{cNl.pl(WSP)}));
    public static final BNF concatenation = REG.rule("concatenation", Concatenation.class, repetition.pl(new BNF[]{cWsp.ix().pl(repetition).x()}));
    public static final BNF alternation = REG.rule("alternation", Alternation.class, concatenation.pl(new BNF[]{cWsp.x().pl(new BNF[]{BNF.text('/'), cWsp.x(), concatenation}).x()}));
    public static final BNF group = REG.rule("group", SubAlternation.class, BNF.bin(40).pl(new BNF[]{cWsp.x(), alternation, cWsp.x(), BNF.bin(41)}));
    public static final BNF option = REG.rule("option", Option.class, BNF.bin(91).pl(new BNF[]{cWsp.x(), alternation, cWsp.x(), BNF.bin(93)}));
    public static final BNF element = REG.rule("element", Element.class, rulename.or1(group, option, charVal, numVal, proseVal));
    public static final BNF elements = REG.rule("elements", SubAlternation.class, alternation.pl(new BNF[]{cWsp.x()}));
    public static final BNF definedAs = REG.rule("defined-as", BNFStringParser.class, cWsp.x().pl(new BNF[]{BNF.bin(61).or(BNF.bin("=/")), cWsp.x()}));
    public static final BNF rule = REG.rule("rule", Rule.class, rulename.pl(definedAs, elements, cNl));
    public static final BNF rulelist = REG.rule("rulelist", Rulelist.class, rule.or1(new BNF[]{cWsp.x().pl(cNl)}).ix());

    public static BNFCC<BNF> copyREG() {
        BNFCC<BNF> reg = BNFCC.abnf(BASE, null);
        reg.rule("char-val", CharVal.class, charVal);
        reg.rule("bin-val", NumVal.BinVal.class, binVal);
        reg.rule("dec-val", NumVal.DecVal.class, decVal);
        reg.rule("hex-val", NumVal.HexVal.class, hexVal);
        reg.rule("prose-val", ProseVal.class, proseVal);
        reg.rule("num-val", NumVal.class, BNF.text('%').pl(new BNF[]{reg.ref("bin-val").or1(new BNF[]{reg.ref("dec-val"), reg.ref("hex-val")})}));
        reg.rule("rulename", Rulename.class, rulename);
        reg.rule("element", Element.class, reg.ref("rulename").or1(new BNF[]{reg.ref("group"), reg.ref("option"), reg.ref("char-val"), reg.ref("num-val"), reg.ref("prose-val")}));
        reg.rule("comment", comment);
        reg.rule("repeat", BNFStringParser.class, DIGIT.x().pl(new BNF[]{BNF.bin(42), DIGIT.x()}).or1(new BNF[]{DIGIT.ix()}));
        reg.rule("repetition", Repetition.class, reg.ref("repeat").c().pl(new BNF[]{reg.ref("element")}));
        reg.rule("c-nl", reg.ref("comment").or1(CRLF));
        reg.rule("c-wsp", WSP.or1(new BNF[]{cNl.pl(WSP)}));
        reg.rule("concatenation", Concatenation.class, reg.ref("repetition").pl(new BNF[]{cWsp.ix().pl(new BNF[]{reg.ref("repetition")}).x()}));
        reg.rule("alternation", Alternation.class, reg.ref("concatenation").pl(new BNF[]{cWsp.x().pl(new BNF[]{BNF.text('/'), cWsp.x(), reg.ref("concatenation")}).x()}));
        reg.rule("group", SubAlternation.class, BNF.bin(40).pl(new BNF[]{cWsp.x(), reg.ref("alternation"), cWsp.x(), BNF.bin(41)}));
        reg.rule("option", Option.class, BNF.bin(91).pl(new BNF[]{cWsp.x(), reg.ref("alternation"), cWsp.x(), BNF.bin(93)}));
        reg.rule("elements", SubAlternation.class, reg.ref("alternation").pl(new BNF[]{cWsp.x()}));
        reg.rule("defined-as", BNFStringParser.class, definedAs);
        reg.rule("rule", Rule.class, reg.ref("rulename").pl(new BNF[]{definedAs, reg.ref("elements"), cNl}));
        reg.rule("rulelist", Rulelist.class, reg.ref("rule").or1(new BNF[]{cWsp.x().pl(cNl)}).ix());
        return reg;
    }
}

