/*
 * Decompiled with CFR 0.152.
 */
package net.siisise.bnf.parser5234;

import net.siisise.block.ReadableBlock;
import net.siisise.bnf.BNF;
import net.siisise.bnf.parser.BNFBaseParser;
import net.siisise.io.Input;
import net.siisise.io.PacketA;
import net.siisise.lang.CodePoint;

class NumSub
extends BNFBaseParser<BNF> {
    private static final BNF hf = BNF.bin(45);
    private static final BNF dot = BNF.bin(46);
    private final BNF nrule;
    private final int dig;
    private final char a;
    private final char b;

    NumSub(BNF rule, BNF numrule, int dig, char a, char b) {
        super(rule);
        this.nrule = numrule.ix();
        this.dig = dig;
        this.a = a;
        this.b = b;
    }

    @Override
    public BNF parse(ReadableBlock pac) {
        int c = pac.read();
        if (c != this.a && c != this.b) {
            pac.back(1L);
            return null;
        }
        int v = this.num(pac);
        ReadableBlock r = hf.is(pac);
        if (r != null) {
            int max = this.num(pac);
            return BNF.range(v, max);
        }
        r = dot.is(pac);
        if (r == null) {
            return BNF.bin(v);
        }
        PacketA data = new PacketA();
        data.write(CodePoint.utf8((int)v));
        do {
            data.write(CodePoint.utf8((int)this.num(pac)));
        } while ((r = dot.is(pac)) != null);
        return BNF.bin(NumSub.str((Input)data));
    }

    private int num(ReadableBlock pac) {
        ReadableBlock num = this.nrule.is(pac);
        return Integer.parseInt(NumSub.str((Input)num), this.dig);
    }
}

