/*
 * Decompiled with CFR 0.152.
 */
package net.siisise.ebnf;

import java.util.Arrays;
import net.siisise.block.ReadableBlock;
import net.siisise.bnf.BNFReg;
import net.siisise.ebnf.EBNF;
import net.siisise.ebnf.IsEBNF;
import net.siisise.lang.CodePoint;

public class EBNFbin
extends IsEBNF {
    private final byte[] data;

    EBNFbin(int ch) {
        this.name = ch >= 32 && (ch != 34 && ch < 65 || ch > 90 && ch < 97 || ch > 122 && ch < 127) ? "\"" + (char)ch + "\"" : this.uhex(ch);
        this.data = CodePoint.utf8((int)ch);
    }

    EBNFbin(String val) {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.uhex(val.charAt(0)));
        for (int i = 1; i < val.length(); ++i) {
            sb.append(".");
            sb.append(this.uhex(val.charAt(i)).substring(2));
        }
        this.name = sb.toString();
        this.data = val.getBytes(UTF8);
    }

    @Override
    public EBNFbin copy(BNFReg<EBNF> reg) {
        return new EBNFbin(new String(this.data, UTF8));
    }

    @Override
    public ReadableBlock is(ReadableBlock pac) {
        if (pac.length() < 1L) {
            return null;
        }
        byte[] d = new byte[this.data.length];
        int dlsize = pac.read(d);
        if (dlsize < this.data.length || !Arrays.equals(this.data, d)) {
            pac.back((long)dlsize);
            return null;
        }
        return ReadableBlock.wrap((byte[])d);
    }

    @Override
    public String toJava() {
        StringBuilder src = new StringBuilder("EBNF.bin(");
        src.append(this.name);
        src.append(")");
        return src.toString();
    }
}

