/*
 * Decompiled with CFR 0.152.
 */
package net.siisise.ebnf;

import java.util.ArrayList;
import net.siisise.block.ReadableBlock;
import net.siisise.bnf.BNF;
import net.siisise.bnf.BNFReg;
import net.siisise.bnf.parser.BNFParser;
import net.siisise.ebnf.EBNF;
import net.siisise.ebnf.EBNFtext;
import net.siisise.ebnf.FindEBNF;
import net.siisise.lang.CodePoint;

public class EBNFor
extends FindEBNF {
    private BNF[] list;

    public EBNFor(BNF ... ebnfs) {
        this.list = ebnfs;
        this.name = EBNFor.toName(ebnfs);
    }

    public EBNFor(String n, BNF ... ebnfs) {
        this.name = n;
        this.list = ebnfs;
    }

    public EBNFor(String chlist) {
        ReadableBlock src = EBNFor.rb(chlist);
        ArrayList<EBNFtext> abnfs = new ArrayList<EBNFtext>();
        while (src.length() > 0L) {
            abnfs.add(new EBNFtext(CodePoint.utf8((ReadableBlock)src)));
        }
        this.list = abnfs.toArray(new BNF[abnfs.size()]);
        this.name = EBNFor.toName(this.list);
    }

    public EBNFor(String name, String list) {
        ReadableBlock p = EBNFor.rb(list);
        ArrayList<EBNFtext> fs = new ArrayList<EBNFtext>();
        while (p.length() > 0L) {
            fs.add(new EBNFtext(CodePoint.utf8((ReadableBlock)p)));
        }
        this.list = fs.toArray(new BNF[0]);
        this.name = name;
    }

    static String toName(BNF[] abnfs) {
        StringBuilder sb = new StringBuilder();
        sb.append("( ");
        for (BNF v : abnfs) {
            String n = v.getName();
            if (v instanceof EBNFor && n.startsWith("( ") && n.endsWith(" )")) {
                n = n.substring(2, n.length() - 2);
                sb.append(n);
            } else {
                sb.append(v.getName());
            }
            sb.append(" / ");
        }
        sb.delete(sb.length() - 3, sb.length());
        sb.append(" )");
        return sb.toString();
    }

    @Override
    public EBNFor copy(BNFReg<EBNF> reg) {
        BNF[] l = new BNF[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            l[i] = this.list[i].copy(reg);
        }
        return new EBNFor(this.name, l);
    }

    public void add(BNF ... val) {
        BNF[] n = new BNF[this.list.length + val.length];
        System.arraycopy(this.list, 0, n, 0, this.list.length);
        System.arraycopy(val, 0, n, this.list.length, val.length);
        if (this.name.contains("(")) {
            this.name = EBNFor.toName(n);
        }
        this.list = n;
    }

    @Override
    public <X> BNF.Match<X> buildFind(ReadableBlock pac, Object ns, BNFParser<? extends X> ... parsers) {
        long bp;
        BNF.Match<? extends X> ret = null;
        long o = bp = pac.backLength();
        for (BNF sub : this.list) {
            BNF.Match<? extends X> subret = sub.find(pac, ns, parsers);
            if (subret == null) continue;
            long datasize = subret.sub.length();
            if (ret == null || ret.sub.length() < datasize) {
                o = bp + datasize;
                ret = subret;
            }
            pac.seek(bp);
        }
        if (ret != null) {
            pac.seek(o);
        }
        return ret;
    }

    @Override
    public String toJava() {
        StringBuilder src = new StringBuilder();
        src.append(this.list[0].toJava());
        if (this.list.length > 1) {
            src.append(".or(");
            for (int i = 1; i < this.list.length - 1; ++i) {
                src.append(this.list[i].toJava());
                src.append(",");
            }
            src.append(this.list[this.list.length - 1].toJava());
            src.append(")");
        }
        return src.toString();
    }
}

