/*
 * Decompiled with CFR 0.152.
 */
package net.siisise.ebnf;

import net.siisise.block.ReadableBlock;
import net.siisise.bnf.BNFReg;
import net.siisise.ebnf.EBNF;
import net.siisise.ebnf.IsEBNF;
import net.siisise.lang.CodePoint;

public class EBNFrange
extends IsEBNF {
    private final int min;
    private final int max;

    public EBNFrange(int min, int max) {
        this.min = min;
        this.max = max;
        this.name = this.uhex(min) + "-" + this.uhex(max).substring(2);
    }

    @Override
    public EBNFrange copy(BNFReg<EBNF> reg) {
        return new EBNFrange(this.min, this.max);
    }

    @Override
    public ReadableBlock is(ReadableBlock pac) {
        if (pac.length() == 0L) {
            return null;
        }
        long of = pac.backLength();
        int ch = CodePoint.utf8((ReadableBlock)pac);
        if (ch < 0) {
            pac.seek(of);
            return null;
        }
        byte[] bin8 = CodePoint.utf8((int)ch);
        if (ch >= this.min && ch <= this.max) {
            return ReadableBlock.wrap((byte[])bin8);
        }
        pac.seek(of);
        return null;
    }

    @Override
    public String toJava() {
        return "EBNF.range(0x" + Integer.toHexString(this.min) + ", 0x" + Integer.toHexString(this.max) + ")";
    }
}

