/*
 * Decompiled with CFR 0.152.
 */
package net.siisise.ebnf;

import net.siisise.block.ReadableBlock;
import net.siisise.bnf.BNFReg;
import net.siisise.ebnf.EBNF;
import net.siisise.ebnf.EBNFor;
import net.siisise.ebnf.IsEBNF;

public class EBNFtext
extends IsEBNF {
    private final String text;
    private final byte[] utf8;

    EBNFtext(int ch) {
        char[] chars = Character.toChars(ch);
        this.text = String.valueOf(chars);
        this.name = ch < 127 && ch >= 32 && ch != 34 ? "\"" + this.text + "\"" : this.uhex(ch);
        this.utf8 = this.text.getBytes(UTF8);
    }

    EBNFtext(String text) {
        this.text = text;
        this.name = "\"" + text + "\"";
        this.utf8 = text.getBytes(UTF8);
    }

    @Override
    public EBNFtext copy(BNFReg<EBNF> reg) {
        return new EBNFtext(this.text);
    }

    public static EBNF list(String chlist) {
        return new EBNFor(chlist);
    }

    @Override
    public ReadableBlock is(ReadableBlock pac) {
        if (pac.length() < 1L) {
            return null;
        }
        byte[] d = new byte[this.utf8.length];
        int size = pac.read(d);
        if (size < this.utf8.length) {
            pac.back((long)size);
            return null;
        }
        String u = new String(d, UTF8);
        if (u.equalsIgnoreCase(this.text)) {
            return ReadableBlock.wrap((byte[])d);
        }
        pac.back((long)d.length);
        return null;
    }

    @Override
    public String toJava() {
        return "EBNF.text(" + this.text + ")";
    }
}

