/*
 * Decompiled with CFR 0.152.
 */
package jp.ad.sinet.stream.plugins.mqtt;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.ad.sinet.stream.api.AuthenticationException;
import jp.ad.sinet.stream.api.ConnectionException;
import jp.ad.sinet.stream.api.Consistency;
import jp.ad.sinet.stream.api.InvalidConfigurationException;
import jp.ad.sinet.stream.api.ValueType;
import jp.ad.sinet.stream.api.valuetype.SimpleValueType;
import jp.ad.sinet.stream.plugins.mqtt.MqttVersion;
import jp.ad.sinet.stream.utils.KeyStoreUtil;
import jp.ad.sinet.stream.utils.MessageUtils;
import lombok.Generated;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;

public abstract class AbstractMqttIO<T> {
    @Generated
    private static final Logger log = Logger.getLogger(AbstractMqttIO.class.getName());
    final T client;
    protected final String service;
    protected final Consistency consistency;
    protected final Map<String, Object> config;
    protected final ValueType valueType;
    protected final boolean retain;
    protected final boolean dataEncryption;
    final MqttConnectOptions connectOptions;
    private final String websocketPath;
    int reconnectMinDelay = 1;
    int reconnectDelay = 1;
    protected final AtomicBoolean closed = new AtomicBoolean(false);

    AbstractMqttIO(String service, Consistency consistency, String clientId, Map<String, ?> config, ValueType valueType, boolean dataEncryption) {
        this.service = service;
        this.config = Collections.unmodifiableMap(config);
        this.valueType = valueType;
        this.consistency = this.setupConsistency(consistency);
        this.retain = this.setupRetain();
        this.connectOptions = this.setupConnectOptions();
        this.dataEncryption = dataEncryption;
        this.websocketPath = this.getWebSocketPath();
        String realClientId = Optional.ofNullable(clientId).filter(x -> x.trim().length() > 0).orElseGet(MqttClient::generateClientId);
        log.fine(() -> "mqtt clientid = " + realClientId);
        this.client = this.newMqttClient(realClientId);
    }

    protected abstract T newMqttClient(String var1);

    protected abstract IMqttToken mqttConnect(MqttConnectOptions var1) throws MqttException;

    protected MqttClientPersistence getPersistence() {
        Path dataDir = Paths.get(System.getProperty("user.home"), ".mqtt-persistence");
        return new MqttDefaultFilePersistence(dataDir.normalize().toString());
    }

    void connect() {
        if (this.closed.get()) {
            return;
        }
        log.fine(() -> "Connect to the broker: " + this.getClientId());
        try {
            IMqttToken ret = this.mqttConnect(this.connectOptions);
            log.fine(() -> "connect complete: " + ret.getResponse().toString());
        }
        catch (MqttSecurityException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSuchAlgorithmException) {
                throw new ConnectionException((Throwable)e);
            }
            throw new AuthenticationException((Throwable)e);
        }
        catch (MqttException e) {
            throw new ConnectionException((Throwable)e);
        }
    }

    private MqttConnectOptions setupConnectOptions() {
        MqttConnectOptions opts = new MqttConnectOptions();
        Optional.ofNullable(this.config.get("username_pw_set")).filter(Map.class::isInstance).map(Map.class::cast).ifPresent(x -> {
            Optional.ofNullable(x.get("username")).filter(String.class::isInstance).map(String.class::cast).ifPresent(arg_0 -> ((MqttConnectOptions)opts).setUserName(arg_0));
            Optional.ofNullable(x.get("password")).filter(String.class::isInstance).map(String.class::cast).map(String::toCharArray).ifPresent(arg_0 -> ((MqttConnectOptions)opts).setPassword(arg_0));
        });
        Optional.ofNullable(this.config.get("protocol")).filter(String.class::isInstance).map(String.class::cast).map(AbstractMqttIO.loggingException(MqttVersion::valueOf)).map(MqttVersion::getValue).ifPresent(arg_0 -> ((MqttConnectOptions)opts).setMqttVersion(arg_0));
        Optional.ofNullable(this.config.get("max_inflight_messages_set")).map(AbstractMqttIO.loggingException(MessageUtils::toInteger)).ifPresent(arg_0 -> ((MqttConnectOptions)opts).setMaxInflight(arg_0));
        Optional.ofNullable(this.config.get("clean_session")).map(AbstractMqttIO.loggingException(MessageUtils::toBoolean)).ifPresent(arg_0 -> ((MqttConnectOptions)opts).setCleanSession(arg_0));
        Optional.ofNullable(this.config.get("ws_set_options")).filter(Map.class::isInstance).map(Map.class::cast).flatMap(wsOpt -> Optional.ofNullable(wsOpt.get("headers")).map(headers -> {
            if (headers instanceof Properties) {
                return (Properties)headers;
            }
            if (headers instanceof Map) {
                Properties ps = new Properties();
                ps.putAll((Map<?, ?>)((Map)headers));
                return ps;
            }
            return null;
        })).ifPresent(arg_0 -> ((MqttConnectOptions)opts).setCustomWebSocketHeaders(arg_0));
        Optional.ofNullable(this.config.get("reconnect_delay_set")).filter(Map.class::isInstance).map(Map.class::cast).ifPresent(delayOpt -> {
            Optional.ofNullable(delayOpt.get("max_delay")).map(AbstractMqttIO.loggingException(MessageUtils::toInteger)).ifPresent(arg_0 -> ((MqttConnectOptions)opts).setMaxReconnectDelay(arg_0));
            Optional.ofNullable(delayOpt.get("min_delay")).map(AbstractMqttIO.loggingException(MessageUtils::toInteger)).ifPresent(v -> {
                this.reconnectMinDelay = this.reconnectDelay = v.intValue();
            });
        });
        Optional.ofNullable(this.config.get("connect")).filter(Map.class::isInstance).map(Map.class::cast).ifPresent(connectOpts -> {
            Optional.ofNullable(connectOpts.get("keepalive")).map(AbstractMqttIO.loggingException(MessageUtils::toInteger)).ifPresent(arg_0 -> ((MqttConnectOptions)opts).setKeepAliveInterval(arg_0));
            Optional.ofNullable(connectOpts.get("automatic_reconnect")).map(AbstractMqttIO.loggingException(MessageUtils::toBoolean)).ifPresent(arg_0 -> ((MqttConnectOptions)opts).setAutomaticReconnect(arg_0));
            Optional.ofNullable(connectOpts.get("connection_timeout")).map(AbstractMqttIO.loggingException(MessageUtils::toInteger)).ifPresent(arg_0 -> ((MqttConnectOptions)opts).setConnectionTimeout(arg_0));
            Optional.ofNullable(connectOpts.get("executor_service_timeout")).map(AbstractMqttIO.loggingException(MessageUtils::toInteger)).ifPresent(arg_0 -> ((MqttConnectOptions)opts).setExecutorServiceTimeout(arg_0));
        });
        this.setupSSLOptions(opts);
        try {
            this.setupWill(opts);
        }
        catch (RuntimeException e) {
            log.warning(e.getMessage());
        }
        return opts;
    }

    private String getWebSocketPath() {
        return Optional.ofNullable(this.config.get("ws_set_options")).filter(Map.class::isInstance).map(Map.class::cast).flatMap(opts -> Optional.ofNullable(opts.get("path")).filter(String.class::isInstance).map(String.class::cast)).orElse(null);
    }

    private void setupSSLOptions(MqttConnectOptions opts) {
        HashMap tls = new HashMap();
        for (String key : Arrays.asList("tls", "tls_set")) {
            Optional.ofNullable(this.config.get(key)).filter(Map.class::isInstance).map(Map.class::cast).ifPresent(tls::putAll);
        }
        tls.putAll(KeyStoreUtil.setupKeyStore(tls));
        this.setupSSLProperties(opts, tls);
        this.setupHttpsHostnameVerification(opts, tls);
    }

    private void setupSSLProperties(MqttConnectOptions opts, Map tls) {
        Properties sslProps = new Properties();
        HashMap<String, String> paramsNameMap = new HashMap<String, String>();
        paramsNameMap.put("tls_version", "protocol");
        paramsNameMap.put("ciphers", "enabledCipherSuites");
        paramsNameMap.forEach((key1, value) -> Optional.ofNullable(tls.get(key1)).ifPresent(v -> sslProps.setProperty("com.ibm.ssl." + value, v.toString())));
        List<String> keys = Arrays.asList("keyStore", "keyStorePassword", "keyStoreType", "trustStore", "trustStorePassword", "trustStoreType", "enabledCipherSuites", "protocol", "contextProvider", "keyStoreProvider", "trustStoreProvider", "keyManager", "trustManager");
        for (String key : keys) {
            Optional.ofNullable(tls.get(key)).ifPresent(v -> sslProps.setProperty("com.ibm.ssl." + key, v.toString()));
        }
        if (sslProps.size() > 0) {
            opts.setSSLProperties(sslProps);
        }
    }

    private void setupHttpsHostnameVerification(MqttConnectOptions opts, Map tls) {
        AtomicReference checkHostname = new AtomicReference();
        Optional.ofNullable(tls.get("check_hostname")).filter(String.class::isInstance).map(String.class::cast).map(Boolean::parseBoolean).ifPresent(checkHostname::set);
        Optional.ofNullable(tls.get("check_hostname")).filter(Boolean.class::isInstance).map(Boolean.class::cast).ifPresent(checkHostname::set);
        Optional.ofNullable(this.config.get("tls_insecure_set")).filter(Map.class::isInstance).map(Map.class::cast).ifPresent(insecure -> {
            try {
                Optional.of(insecure.get("value")).map(opt -> MessageUtils.toBoolean((Object)opt.toString()) == false).ifPresent(checkHostname::set);
            }
            catch (Throwable e) {
                throw new InvalidConfigurationException("tls_insecure_set: value cannot cast to boolean.", e);
            }
        });
        if (Objects.nonNull(checkHostname.get())) {
            opts.setHttpsHostnameVerificationEnabled(((Boolean)checkHostname.get()).booleanValue());
        }
    }

    private void setupWill(MqttConnectOptions opts) {
        Optional.ofNullable(this.config.get("will_set")).filter(Map.class::isInstance).map(Map.class::cast).ifPresent(will -> {
            boolean willRetain = Optional.ofNullable(will.get("retain")).map(MessageUtils::toBoolean).orElse(this.retain);
            int willQos = Optional.ofNullable(will.get("qos")).map(MessageUtils::toInteger).orElseGet(() -> ((Consistency)this.consistency).getQos());
            String willTopic = Optional.ofNullable(will.get("topic")).filter(String.class::isInstance).map(String.class::cast).orElseThrow(() -> new InvalidConfigurationException("The topic is not set."));
            Optional.ofNullable(will.get("payload")).map(AbstractMqttIO.loggingException(x -> {
                if (x instanceof byte[]) {
                    return (byte[])x;
                }
                if (x instanceof String) {
                    return SimpleValueType.TEXT.getSerializer().serialize(x);
                }
                return this.valueType.getSerializer().serialize(x);
            })).ifPresent(payload -> opts.setWill(willTopic, payload, willQos, willRetain));
        });
    }

    private static <T, R> Function<T, R> loggingException(Function<? super T, ? extends R> mapper) {
        return v -> {
            try {
                return mapper.apply(v);
            }
            catch (Throwable e) {
                log.warning(e.getMessage());
                log.log(Level.FINER, e, e::getMessage);
                return null;
            }
        };
    }

    private Consistency setupConsistency(Consistency consistency) {
        return Optional.ofNullable(this.config.get("qos")).filter(String.class::isInstance).map(String.class::cast).map(AbstractMqttIO.loggingException(Integer::parseInt)).map(Consistency::valueOf).orElseGet(() -> Optional.ofNullable(this.config.get("qos")).filter(Integer.class::isInstance).map(Integer.class::cast).map(Consistency::valueOf).orElse(consistency));
    }

    private boolean setupRetain() {
        AtomicReference retain = new AtomicReference();
        Optional.ofNullable(this.config.get("retain")).filter(String.class::isInstance).map(String.class::cast).map(Boolean::parseBoolean).ifPresent(retain::set);
        Optional.ofNullable(this.config.get("retain")).filter(Boolean.class::isInstance).map(Boolean.class::cast).ifPresent(retain::set);
        return Optional.ofNullable((Boolean)retain.get()).orElse(false);
    }

    protected String getServerURI() {
        Object x = this.config.get("brokers");
        if (Objects.isNull(x)) {
            throw new InvalidConfigurationException();
        }
        if (x instanceof List) {
            List xs = (List)x;
            if (xs.size() != 1) {
                throw new InvalidConfigurationException();
            }
            x = xs.get(0);
        }
        if (x instanceof String) {
            String addr = this.addressToURI((String)x);
            log.fine(() -> "broker address = " + addr);
            return addr;
        }
        throw new InvalidConfigurationException();
    }

    private boolean isSecure() {
        return Optional.ofNullable(this.config.get("tls_set")).map(x -> {
            if (x instanceof Map) {
                return ((Map)x).size() > 0;
            }
            return null;
        }).orElseGet(() -> Optional.ofNullable(this.config.get("tls")).map(x -> {
            if (x instanceof Map) {
                return ((Map)x).size() > 0;
            }
            if (x instanceof Boolean) {
                return (Boolean)x;
            }
            return null;
        }).orElse(false));
    }

    private boolean isWebSocket() {
        return Optional.ofNullable(this.config.get("transport")).filter(String.class::isInstance).map(String.class::cast).map(String::toLowerCase).filter("websockets"::equals).isPresent();
    }

    private String getUriPrefix() {
        if (this.isWebSocket()) {
            if (this.isSecure()) {
                return "wss://";
            }
            return "ws://";
        }
        if (this.isSecure()) {
            return "ssl://";
        }
        return "tcp://";
    }

    private String addressToURI(String x) {
        if (!this.isWebSocket() || Objects.isNull(this.websocketPath)) {
            return this.getUriPrefix() + x;
        }
        return this.getUriPrefix() + x + this.websocketPath;
    }

    public abstract String getClientId();

    public final void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.doClose();
    }

    protected abstract void doClose();

    @Generated
    public String getService() {
        return this.service;
    }

    @Generated
    public Consistency getConsistency() {
        return this.consistency;
    }

    @Generated
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @Generated
    public ValueType getValueType() {
        return this.valueType;
    }

    @Generated
    public boolean isRetain() {
        return this.retain;
    }

    @Generated
    public boolean isDataEncryption() {
        return this.dataEncryption;
    }

    @Generated
    public MqttConnectOptions getConnectOptions() {
        return this.connectOptions;
    }

    @Generated
    public int getReconnectDelay() {
        return this.reconnectDelay;
    }

    @Generated
    public void setReconnectDelay(int reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }
}

