/*
 * Decompiled with CFR 0.152.
 */
package jp.ad.sinet.stream.plugins.mqtt;

import java.util.Map;
import java.util.logging.Logger;
import jp.ad.sinet.stream.api.Consistency;
import jp.ad.sinet.stream.api.SinetStreamException;
import jp.ad.sinet.stream.api.SinetStreamIOException;
import jp.ad.sinet.stream.api.ValueType;
import jp.ad.sinet.stream.plugins.mqtt.AbstractMqttIO;
import lombok.Generated;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;

public class MqttAsyncBaseIO
extends AbstractMqttIO<MqttAsyncClient> {
    @Generated
    private static final Logger log = Logger.getLogger(MqttAsyncBaseIO.class.getName());

    MqttAsyncBaseIO(String service, Consistency consistency, String clientId, Map<String, ?> config, ValueType valueType, boolean dataEncryption) {
        super(service, consistency, clientId, config, valueType, dataEncryption);
    }

    @Override
    protected MqttAsyncClient newMqttClient(String realClientId) {
        try {
            return new MqttAsyncClient(this.getServerURI(), realClientId, this.getPersistence());
        }
        catch (MqttException e) {
            throw new SinetStreamException((Throwable)e);
        }
    }

    @Override
    protected IMqttToken mqttConnect(MqttConnectOptions opts) throws MqttException {
        IMqttToken ret = ((MqttAsyncClient)this.client).connect(this.connectOptions);
        ret.waitForCompletion();
        return ret;
    }

    @Override
    public String getClientId() {
        return ((MqttAsyncClient)this.client).getClientId();
    }

    @Override
    protected void doClose() {
        try {
            if (((MqttAsyncClient)this.client).isConnected()) {
                log.fine(() -> "Disconnect the broker: " + this.getClientId());
                ((MqttAsyncClient)this.client).disconnect().waitForCompletion();
            }
            log.fine(() -> "close MQTT client: " + this.getClientId());
            ((MqttAsyncClient)this.client).close();
        }
        catch (MqttException e) {
            throw new SinetStreamIOException((Throwable)e);
        }
    }

    public Object getMetrics() {
        return null;
    }

    public void resetMetrics() {
    }
}

