/*
 * Decompiled with CFR 0.152.
 */
package jp.ad.sinet.stream.plugins.mqtt;

import java.util.Arrays;
import java.util.logging.Logger;
import jp.ad.sinet.stream.api.SinetStreamIOException;
import jp.ad.sinet.stream.plugins.mqtt.MqttSyncBaseIO;
import jp.ad.sinet.stream.spi.PluginMessageWriter;
import jp.ad.sinet.stream.spi.WriterParameters;
import jp.ad.sinet.stream.utils.Timestamped;
import lombok.Generated;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;

public class MqttMessageWriter
extends MqttSyncBaseIO
implements PluginMessageWriter {
    @Generated
    private static final Logger log = Logger.getLogger(MqttMessageWriter.class.getName());
    private final String topic;

    MqttMessageWriter(WriterParameters parameters) {
        super(parameters.getService(), parameters.getConsistency(), parameters.getClientId(), parameters.getConfig(), parameters.getValueType(), parameters.isDataEncryption());
        this.topic = parameters.getTopic();
        this.connect();
    }

    public void write(Timestamped<byte[]> message) {
        try {
            log.finer(() -> "MQTT publish: " + this.getClientId() + ": " + Arrays.toString((byte[])message.getValue()));
            ((MqttClient)this.client).publish(this.topic, (byte[])message.getValue(), this.consistency.getQos(), this.retain);
        }
        catch (MqttException e) {
            throw new SinetStreamIOException((Throwable)e);
        }
    }

    @Generated
    public String getTopic() {
        return this.topic;
    }
}

