/*
 * Decompiled with CFR 0.152.
 */
package jp.ad.sinet.stream.plugins.mqtt;

import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.ad.sinet.stream.plugins.mqtt.MqttReader;
import jp.ad.sinet.stream.plugins.mqtt.SinetMqttMessage;
import lombok.Generated;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MqttReaderCallback
implements MqttCallback {
    @Generated
    private static final Logger log = Logger.getLogger(MqttReaderCallback.class.getName());
    private final MqttReader reader;

    public MqttReaderCallback(MqttReader reader) {
        this.reader = reader;
    }

    public void connectionLost(Throwable cause) {
        log.log(Level.FINE, cause, () -> "MQTT connection lost: " + this.reader.getClientId());
        if (!this.reader.getConnectOptions().isAutomaticReconnect()) {
            this.reader.onConnectionLost(cause);
            return;
        }
        Executors.newSingleThreadScheduledExecutor().schedule(() -> {
            this.updateReconnectDelay();
            this.disconnectClient();
            this.reader.connect();
        }, (long)this.reader.getReconnectDelay(), TimeUnit.SECONDS);
    }

    private void disconnectClient() {
        try {
            log.fine(() -> "Disconnect the broker: " + this.reader.getClientId());
            this.reader.disconnect();
        }
        catch (MqttException e) {
            log.log(Level.FINER, e, () -> "MQTT disconnect ERROR: " + this.reader.getClientId());
        }
    }

    private void updateReconnectDelay() {
        if (this.reader.getReconnectDelay() < this.reader.getConnectOptions().getMaxReconnectDelay()) {
            this.reader.setReconnectDelay(this.reader.getReconnectDelay() * 2);
        }
        if (this.reader.getReconnectDelay() > this.reader.getConnectOptions().getMaxReconnectDelay()) {
            this.reader.setReconnectDelay(this.reader.getConnectOptions().getMaxReconnectDelay());
        }
    }

    public void messageArrived(String topic, MqttMessage message) {
        log.finer(() -> "MQTT message arrived: " + this.reader.getClientId() + ": " + message.toString());
        this.reader.onMessageArrived(new SinetMqttMessage(topic, message));
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
        log.finest(() -> "MQTT delivery completed: " + token.toString());
    }
}

