/*
 * Decompiled with CFR 0.152.
 */
package jp.ad.sinet.stream.plugins.mqtt;

import java.util.Map;
import java.util.logging.Logger;
import jp.ad.sinet.stream.api.Consistency;
import jp.ad.sinet.stream.api.SinetStreamException;
import jp.ad.sinet.stream.api.SinetStreamIOException;
import jp.ad.sinet.stream.api.ValueType;
import jp.ad.sinet.stream.plugins.mqtt.AbstractMqttIO;
import lombok.Generated;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;

public class MqttSyncBaseIO
extends AbstractMqttIO<MqttClient> {
    @Generated
    private static final Logger log = Logger.getLogger(MqttSyncBaseIO.class.getName());

    MqttSyncBaseIO(String service, Consistency consistency, String clientId, Map<String, ?> config, ValueType valueType, boolean dataEncryption) {
        super(service, consistency, clientId, config, valueType, dataEncryption);
    }

    @Override
    protected MqttClient newMqttClient(String realClientId) {
        try {
            return new MqttClient(this.getServerURI(), realClientId, this.getPersistence());
        }
        catch (MqttException e) {
            throw new SinetStreamException((Throwable)e);
        }
    }

    @Override
    protected IMqttToken mqttConnect(MqttConnectOptions opts) throws MqttException {
        return ((MqttClient)this.client).connectWithResult(opts);
    }

    @Override
    public String getClientId() {
        return ((MqttClient)this.client).getClientId();
    }

    @Override
    protected void doClose() {
        try {
            if (((MqttClient)this.client).isConnected()) {
                log.fine(() -> "Disconnect the broker: " + this.getClientId());
                ((MqttClient)this.client).disconnect();
            }
            log.fine(() -> "close MQTT client: " + this.getClientId());
            ((MqttClient)this.client).close();
        }
        catch (MqttException e) {
            throw new SinetStreamIOException((Throwable)e);
        }
    }

    public Object getMetrics() {
        return null;
    }

    public void resetMetrics() {
    }
}

