/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client;

import com.google.common.base.Strings;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.snowflake.client.TestUtil;
import org.hamcrest.MatcherAssert;

public class AbstractDriverIT {
    public static final String DRIVER_CLASS = "net.snowflake.client.jdbc.SnowflakeDriver";
    public static final String DRIVER_CLASS_COM = "com.snowflake.client.jdbc.SnowflakeDriver";
    public static final int DONT_INJECT_SOCKET_TIMEOUT = 0;
    protected static final String TEST_DATA_FILE = "orders_100.csv";
    protected static final String TEST_DATA_FILE_2 = "orders_101.csv";
    protected static final String[] fileNames = new String[]{"orders_100.csv", "orders_101.csv"};
    private static Logger logger = Logger.getLogger(AbstractDriverIT.class.getName());
    protected final int ERROR_CODE_BIND_VARIABLE_NOT_ALLOWED_IN_VIEW_OR_UDF_DEF = 2210;
    protected final int ERROR_CODE_DOMAIN_OBJECT_DOES_NOT_EXIST = 2003;

    private static String getConnPropKeyFromEnv(String connectionType, String propKey) {
        String envKey = String.format("SNOWFLAKE_%s_%s", connectionType, propKey);
        return envKey;
    }

    private static String getConnPropValueFromEnv(String connectionType, String propKey) {
        String envKey = String.format("SNOWFLAKE_%s_%s", connectionType, propKey);
        return TestUtil.systemGetEnv(envKey);
    }

    public static Map<String, String> getConnectionParameters(String accountName) {
        return AbstractDriverIT.getConnectionParameters(accountName, "TEST");
    }

    public static Map<String, String> getConnectionParameters(String accountName, String connectionType) {
        String host;
        String account;
        HashMap<String, String> params = new HashMap<String, String>();
        if (accountName == null) {
            account = AbstractDriverIT.getConnPropValueFromEnv(connectionType, "ACCOUNT");
            host = AbstractDriverIT.getConnPropValueFromEnv(connectionType, "HOST");
        } else {
            account = accountName;
            String deployment = AbstractDriverIT.getConnPropValueFromEnv(connectionType, "DEPLOYMENT");
            if (Strings.isNullOrEmpty((String)deployment)) {
                deployment = ".reg.local";
            }
            host = accountName.trim() + deployment;
        }
        MatcherAssert.assertThat((String)"set SNOWFLAKE_TEST_ACCOUNT environment variable to the account name.", (!Strings.isNullOrEmpty((String)account) ? 1 : 0) != 0);
        params.put("account", account);
        if (Strings.isNullOrEmpty((String)host)) {
            host = account + ".snowflakecomputing.com";
        }
        MatcherAssert.assertThat((String)"set SNOWFLAKE_TEST_HOST environment variable to the host name.", (!Strings.isNullOrEmpty((String)host) ? 1 : 0) != 0);
        params.put("host", host);
        String protocol = AbstractDriverIT.getConnPropValueFromEnv(connectionType, "PROTOCOL");
        String ssl = "http".equals(protocol) ? "off" : "on";
        params.put("ssl", ssl);
        String user = AbstractDriverIT.getConnPropValueFromEnv(connectionType, "USER");
        MatcherAssert.assertThat((String)"set SNOWFLAKE_TEST_USER environment variable.", (!Strings.isNullOrEmpty((String)user) ? 1 : 0) != 0);
        params.put("user", user);
        String password = AbstractDriverIT.getConnPropValueFromEnv(connectionType, "PASSWORD");
        MatcherAssert.assertThat((String)"set SNOWFLAKE_TEST_PASSWORD environment variable.", (!Strings.isNullOrEmpty((String)password) ? 1 : 0) != 0);
        params.put("password", password);
        String port = AbstractDriverIT.getConnPropValueFromEnv(connectionType, "PORT");
        if (Strings.isNullOrEmpty((String)port)) {
            port = "on".equals(ssl) ? "443" : "80";
        }
        MatcherAssert.assertThat((String)"set SNOWFLAKE_TEST_PORT environment variable.", (!Strings.isNullOrEmpty((String)port) ? 1 : 0) != 0);
        params.put("port", port);
        String database = AbstractDriverIT.getConnPropValueFromEnv(connectionType, "DATABASE");
        MatcherAssert.assertThat((String)"set SNOWFLAKE_TEST_DATABASE environment variable.", (!Strings.isNullOrEmpty((String)database) ? 1 : 0) != 0);
        params.put("database", database);
        String schema = AbstractDriverIT.getConnPropValueFromEnv(connectionType, "SCHEMA");
        MatcherAssert.assertThat((String)"set SNOWFLAKE_TEST_SCHEMA environment variable.", (!Strings.isNullOrEmpty((String)schema) ? 1 : 0) != 0);
        params.put("schema", schema);
        String role = AbstractDriverIT.getConnPropValueFromEnv(connectionType, "ROLE");
        MatcherAssert.assertThat((String)"set SNOWFLAKE_TEST_ROLE environment variable.", (!Strings.isNullOrEmpty((String)role) ? 1 : 0) != 0);
        params.put("role", role);
        String warehouse = AbstractDriverIT.getConnPropValueFromEnv(connectionType, "WAREHOUSE");
        MatcherAssert.assertThat((String)"set SNOWFLAKE_TEST_WAREHOUSE environment variable.", (!Strings.isNullOrEmpty((String)warehouse) ? 1 : 0) != 0);
        params.put("warehouse", warehouse);
        params.put("uri", String.format("jdbc:snowflake://%s:%s", host, port));
        String adminUser = AbstractDriverIT.getConnPropValueFromEnv(connectionType, "ADMIN_USER");
        params.put("adminUser", adminUser);
        String adminPassword = AbstractDriverIT.getConnPropValueFromEnv(connectionType, "ADMIN_PASSWORD");
        params.put("adminPassword", adminPassword);
        String ssoUser = AbstractDriverIT.getConnPropValueFromEnv(connectionType, "SSO_USER");
        params.put("ssoUser", ssoUser);
        String ssoPassword = AbstractDriverIT.getConnPropValueFromEnv(connectionType, "SSO_PASSWORD");
        params.put("ssoPassword", ssoPassword);
        return params;
    }

    public static Map<String, String> getConnectionParameters() {
        return AbstractDriverIT.getConnectionParameters(null);
    }

    public static Connection getConnection(Properties paramProperties) throws SQLException {
        return AbstractDriverIT.getConnection(0, paramProperties, false, false);
    }

    public static Connection getConnection(String accountName) throws SQLException {
        return AbstractDriverIT.getConnection(0, null, false, false, accountName);
    }

    public static Connection getConnection(String accountName, Properties paramProperties) throws SQLException {
        return AbstractDriverIT.getConnection(0, paramProperties, false, false, accountName);
    }

    public static Connection getConnection() throws SQLException {
        return AbstractDriverIT.getConnection(0, null, false, false);
    }

    public static Connection getConnection(int injectSocketTimeout) throws SQLException {
        return AbstractDriverIT.getConnection(injectSocketTimeout, null, false, false);
    }

    protected static Connection getSnowflakeAdminConnection() throws SQLException {
        return AbstractDriverIT.getConnection(0, null, true, false);
    }

    protected static Connection getSnowflakeAdminConnection(Properties paramProperties) throws SQLException {
        return AbstractDriverIT.getConnection(0, paramProperties, true, false);
    }

    public static Connection getConnection(int injectSocketTimeout, Properties paramProperties, boolean isAdmin, boolean usesCom) throws SQLException {
        return AbstractDriverIT.getConnection(injectSocketTimeout, paramProperties, isAdmin, usesCom, null);
    }

    public static Connection getConnection(int injectSocketTimeout, @Nullable Properties paramProperties, boolean isAdmin, boolean usesCom, String accountName) throws SQLException {
        String driverClass = DRIVER_CLASS;
        if (usesCom) {
            driverClass = DRIVER_CLASS_COM;
        }
        try {
            Class.forName(driverClass);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cannot find Driver", e);
            throw new RuntimeException(e.getCause());
        }
        Map<String, String> params = AbstractDriverIT.getConnectionParameters(accountName);
        Properties properties = new Properties();
        if (isAdmin) {
            MatcherAssert.assertThat((String)"set SNOWFLAKE_TEST_ADMIN_USER environment variable.", (!Strings.isNullOrEmpty((String)params.get("adminUser")) ? 1 : 0) != 0);
            MatcherAssert.assertThat((String)"set SNOWFLAKE_TEST_ADMIN_PASSWORD environment variable.", (!Strings.isNullOrEmpty((String)params.get("adminPassword")) ? 1 : 0) != 0);
            properties.put("user", params.get("adminUser"));
            properties.put("password", params.get("adminPassword"));
            properties.put("role", "accountadmin");
            properties.put("account", "snowflake");
        } else {
            properties.put("user", params.get("user"));
            properties.put("password", params.get("password"));
            properties.put("role", params.get("role"));
            properties.put("account", params.get("account"));
        }
        properties.put("db", params.get("database"));
        properties.put("schema", params.get("schema"));
        properties.put("warehouse", params.get("warehouse"));
        properties.put("ssl", params.get("ssl"));
        properties.put("internal", Boolean.TRUE.toString());
        properties.put("insecureMode", (Object)false);
        if (injectSocketTimeout > 0) {
            properties.put("injectSocketTimeout", String.valueOf(injectSocketTimeout));
        }
        if (paramProperties != null) {
            for (Map.Entry<Object, Object> entry : paramProperties.entrySet()) {
                properties.put(entry.getKey(), entry.getValue());
            }
        }
        return DriverManager.getConnection(params.get("uri"), properties);
    }

    public void closeSQLObjects(ResultSet resultSet, Statement statement, Connection connection) throws SQLException {
        if (resultSet != null) {
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (connection != null) {
            connection.close();
        }
    }

    public void closeSQLObjects(Statement statement, Connection connection) throws SQLException {
        if (statement != null) {
            statement.close();
        }
        if (connection != null) {
            connection.close();
        }
    }

    public static String getFullPathFileInResource(String fileName) {
        ClassLoader classLoader = AbstractDriverIT.class.getClassLoader();
        URL url = classLoader.getResource(fileName);
        if (url != null) {
            try {
                return Paths.get(url.toURI()).toAbsolutePath().toString();
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException("Unable to get absolute path: " + fileName);
            }
        }
        throw new RuntimeException("No file is found: " + fileName);
    }

    protected static Timestamp buildTimestamp(int year, int month, int day, int hour, int minute, int second, int fractionInNanoseconds) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, day, hour, minute, second);
        Timestamp ts = new Timestamp(cal.getTime().getTime());
        ts.setNanos(fractionInNanoseconds);
        return ts;
    }

    protected static Date buildDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, day, 0, 0, 0);
        cal.set(14, 0);
        return new Date(cal.getTime().getTime());
    }

    protected static Date buildDateWithTZ(int year, int month, int day, TimeZone tz) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(tz);
        cal.set(year, month, day, 0, 0, 0);
        cal.set(14, 0);
        return new Date(cal.getTime().getTime());
    }
}

