/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.authentication;

import java.util.Properties;
import net.snowflake.client.jdbc.SnowflakeUtil;

public class AuthConnectionParameters {
    static final String SSO_USER = SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_BROWSER_USER");
    static final String HOST = SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_HOST");
    static final String SSO_PASSWORD = SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_OKTA_PASS");
    static final String OKTA = SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_OKTA_NAME");
    static final String OAUTH_PASSWORD = SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_EXTERNAL_OAUTH_OKTA_USER_PASSWORD");

    static Properties getBaseConnectionParameters() {
        Properties properties = new Properties();
        properties.put("host", HOST);
        properties.put("port", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_PORT"));
        properties.put("role", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_ROLE"));
        properties.put("account", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_ACCOUNT"));
        properties.put("db", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_DATABASE"));
        properties.put("schema", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_SCHEMA"));
        properties.put("warehouse", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_WAREHOUSE"));
        properties.put("CLIENT_STORE_TEMPORARY_CREDENTIAL", (Object)false);
        return properties;
    }

    static Properties getExternalBrowserConnectionParameters() {
        Properties properties = AuthConnectionParameters.getBaseConnectionParameters();
        properties.put("user", SSO_USER);
        properties.put("authenticator", "externalbrowser");
        return properties;
    }

    static Properties getStoreIDTokenConnectionParameters() {
        Properties properties = AuthConnectionParameters.getExternalBrowserConnectionParameters();
        properties.put("CLIENT_STORE_TEMPORARY_CREDENTIAL", (Object)true);
        return properties;
    }

    static Properties getOktaConnectionParameters() {
        Properties properties = AuthConnectionParameters.getBaseConnectionParameters();
        properties.put("user", SSO_USER);
        properties.put("password", SSO_PASSWORD);
        properties.put("authenticator", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_OAUTH_URL"));
        return properties;
    }

    static Properties getOauthConnectionParameters(String token) {
        Properties properties = AuthConnectionParameters.getBaseConnectionParameters();
        properties.put("user", SSO_USER);
        properties.put("authenticator", "OAUTH");
        properties.put("token", token);
        return properties;
    }

    static Properties getOAuthExternalAuthorizationCodeConnectionParameters() {
        Properties properties = AuthConnectionParameters.getBaseConnectionParameters();
        properties.put("authenticator", "OAUTH_AUTHORIZATION_CODE");
        properties.put("oauthClientId", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_EXTERNAL_OAUTH_OKTA_CLIENT_ID"));
        properties.put("oauthClientSecret", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_EXTERNAL_OAUTH_OKTA_CLIENT_SECRET"));
        properties.put("oauthRedirectURI", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_EXTERNAL_OAUTH_OKTA_REDIRECT_URI"));
        properties.put("oauthAuthorizationUrl", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_EXTERNAL_OAUTH_OKTA_AUTH_URL"));
        properties.put("oauthTokenRequestUrl", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_EXTERNAL_OAUTH_OKTA_TOKEN"));
        properties.put("user", SSO_USER);
        return properties;
    }

    static Properties getOAuthSnowflakeAuthorizationCodeConnectionParameters() {
        Properties properties = AuthConnectionParameters.getBaseConnectionParameters();
        properties.put("authenticator", "OAUTH_AUTHORIZATION_CODE");
        properties.put("oauthClientId", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_INTERNAL_OAUTH_SNOWFLAKE_CLIENT_ID"));
        properties.put("oauthClientSecret", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_INTERNAL_OAUTH_SNOWFLAKE_CLIENT_SECRET"));
        properties.put("oauthRedirectURI", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_INTERNAL_OAUTH_SNOWFLAKE_REDIRECT_URI"));
        properties.put("role", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_INTERNAL_OAUTH_SNOWFLAKE_ROLE"));
        properties.put("user", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_EXTERNAL_OAUTH_OKTA_CLIENT_ID"));
        return properties;
    }

    static Properties getOAuthSnowflakeWildcardsAuthorizationCodeConnectionParameters() {
        Properties properties = AuthConnectionParameters.getBaseConnectionParameters();
        properties.put("authenticator", "OAUTH_AUTHORIZATION_CODE");
        properties.put("oauthClientId", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_INTERNAL_OAUTH_SNOWFLAKE_WILDCARDS_CLIENT_ID"));
        properties.put("oauthClientSecret", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_INTERNAL_OAUTH_SNOWFLAKE_WILDCARDS_CLIENT_SECRET"));
        properties.put("role", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_INTERNAL_OAUTH_SNOWFLAKE_ROLE"));
        properties.put("user", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_EXTERNAL_OAUTH_OKTA_CLIENT_ID"));
        return properties;
    }

    static Properties getOAuthSnowflakeClientCredentialParameters() {
        Properties properties = AuthConnectionParameters.getBaseConnectionParameters();
        properties.put("authenticator", "OAUTH_CLIENT_CREDENTIALS");
        properties.put("oauthClientId", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_EXTERNAL_OAUTH_OKTA_CLIENT_ID"));
        properties.put("oauthClientSecret", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_EXTERNAL_OAUTH_OKTA_CLIENT_SECRET"));
        properties.put("oauthTokenRequestUrl", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_EXTERNAL_OAUTH_OKTA_TOKEN"));
        properties.put("user", SnowflakeUtil.systemGetEnv((String)"SNOWFLAKE_AUTH_TEST_EXTERNAL_OAUTH_OKTA_CLIENT_ID"));
        return properties;
    }
}

