/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.authentication;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import net.snowflake.client.authentication.AuthConnectionParameters;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;

public class AuthTestHelper {
    private Exception exception;
    private String idToken;
    private String accessToken;
    private final boolean runAuthTestsManually = Boolean.parseBoolean(System.getenv("RUN_AUTH_TESTS_MANUALLY"));

    public Thread getConnectAndExecuteSimpleQueryThread(Properties props, String sessionParameters) {
        return new Thread(() -> this.connectAndExecuteSimpleQuery(props, sessionParameters));
    }

    public Thread getConnectAndExecuteSimpleQueryThread(Properties props) {
        return new Thread(() -> this.connectAndExecuteSimpleQuery(props, null));
    }

    public void verifyExceptionIsThrown(String message) {
        MatcherAssert.assertThat((String)"Expected exception not thrown", (Object)this.exception.getMessage(), (Matcher)CoreMatchers.is((Object)message));
    }

    public void verifyExceptionIsNotThrown() {
        MatcherAssert.assertThat((String)"Unexpected exception thrown", (Object)this.exception, (Matcher)CoreMatchers.nullValue());
    }

    public void connectAndProvideCredentials(Thread provideCredentialsThread, Thread connectThread) throws InterruptedException {
        if (this.runAuthTestsManually) {
            connectThread.start();
            connectThread.join();
        } else {
            provideCredentialsThread.start();
            connectThread.start();
            provideCredentialsThread.join();
            connectThread.join();
        }
    }

    public void provideCredentials(String scenario, String login, String password) {
        try {
            String provideBrowserCredentialsPath = "/externalbrowser/provideBrowserCredentials.js";
            ProcessBuilder processBuilder = new ProcessBuilder("node", provideBrowserCredentialsPath, scenario, login, password);
            Process process = processBuilder.start();
            process.waitFor(15L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void cleanBrowserProcesses() {
        if (!this.runAuthTestsManually) {
            String cleanBrowserProcessesPath = "/externalbrowser/cleanBrowserProcesses.js";
            ProcessBuilder processBuilder = new ProcessBuilder("node", cleanBrowserProcessesPath);
            try {
                Process process = processBuilder.start();
                process.waitFor(15L, TimeUnit.SECONDS);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void deleteIdToken() {
        SessionUtil.deleteIdTokenCache((String)AuthConnectionParameters.HOST, (String)AuthConnectionParameters.SSO_USER);
    }

    public static void deleteIdToken(String host, String user) {
        SessionUtil.deleteIdTokenCache((String)host, (String)user);
    }

    public static void deleteOauthToken() {
        SessionUtil.deleteOAuthAccessTokenCache((String)AuthConnectionParameters.OKTA, (String)AuthConnectionParameters.SSO_USER);
    }

    public static void deleteOauthToken(String host, String user) {
        SessionUtil.deleteOAuthAccessTokenCache((String)host, (String)user);
    }

    public static void deleteOauthRefreshToken(String host, String user) {
        SessionUtil.deleteOAuthRefreshTokenCache((String)host, (String)user);
    }

    public void connectAndExecuteSimpleQuery(Properties props, String sessionParameters) {
        String url = String.format("jdbc:snowflake://%s", props.get("host"));
        if (sessionParameters != null) {
            url = url + "?" + sessionParameters;
        }
        try (Connection con = DriverManager.getConnection(url, props);
             Statement stmt = con.createStatement();
             ResultSet rs = stmt.executeQuery("select 1");){
            Assertions.assertTrue((boolean)rs.next());
            int value = rs.getInt(1);
            Assertions.assertEquals((int)1, (int)value);
            this.saveToken(con);
            this.saveAccessToken(con);
        }
        catch (SQLException e) {
            this.exception = e;
        }
    }

    private void saveToken(Connection con) throws SnowflakeSQLException {
        SnowflakeConnectionV1 sfcon = (SnowflakeConnectionV1)con;
        this.idToken = sfcon.getSfSession().getIdToken();
    }

    private void saveAccessToken(Connection con) throws SnowflakeSQLException {
        SnowflakeConnectionV1 sfcon = (SnowflakeConnectionV1)con;
        this.accessToken = sfcon.getSfSession().getAccessToken();
    }

    public String getIdToken() {
        return this.idToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }
}

