/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.authentication;

import java.io.IOException;
import java.util.Properties;
import net.snowflake.client.authentication.AuthConnectionParameters;
import net.snowflake.client.authentication.AuthTestHelper;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="authentication")
class ExternalBrowserLatestIT {
    String login = AuthConnectionParameters.SSO_USER;
    String password = AuthConnectionParameters.SSO_PASSWORD;
    AuthTestHelper authTestHelper = new AuthTestHelper();
    Properties properties;

    ExternalBrowserLatestIT() {
    }

    @BeforeEach
    public void setUp() throws IOException {
        AuthTestHelper.deleteIdToken();
        this.properties = AuthConnectionParameters.getExternalBrowserConnectionParameters();
    }

    @AfterEach
    public void tearDown() {
        this.authTestHelper.cleanBrowserProcesses();
        AuthTestHelper.deleteIdToken();
    }

    @Test
    void shouldAuthenticateUsingExternalBrowser() throws InterruptedException {
        Thread provideCredentialsThread = new Thread(() -> this.authTestHelper.provideCredentials("success", this.login, this.password));
        Thread connectThread = this.authTestHelper.getConnectAndExecuteSimpleQueryThread(this.properties);
        this.authTestHelper.connectAndProvideCredentials(provideCredentialsThread, connectThread);
        this.authTestHelper.verifyExceptionIsNotThrown();
    }

    @Test
    void shouldThrowErrorForMismatchedUsername() throws InterruptedException {
        this.properties.put("user", "differentUsername");
        Thread provideCredentialsThread = new Thread(() -> this.authTestHelper.provideCredentials("success", this.login, this.password));
        Thread connectThread = this.authTestHelper.getConnectAndExecuteSimpleQueryThread(this.properties);
        this.authTestHelper.connectAndProvideCredentials(provideCredentialsThread, connectThread);
        this.authTestHelper.verifyExceptionIsThrown("The user you were trying to authenticate as differs from the user currently logged in at the IDP.");
    }

    @Test
    void shouldThrowErrorForWrongCredentials() throws InterruptedException {
        String login = "itsnotanaccount.com";
        String password = "fakepassword";
        Thread provideCredentialsThread = new Thread(() -> this.authTestHelper.provideCredentials("fail", login, password));
        Thread connectThread = this.authTestHelper.getConnectAndExecuteSimpleQueryThread(this.properties, "BROWSER_RESPONSE_TIMEOUT=10");
        this.authTestHelper.connectAndProvideCredentials(provideCredentialsThread, connectThread);
        this.authTestHelper.verifyExceptionIsThrown("JDBC driver encountered communication error. Message: External browser authentication failed within timeout of 10000 milliseconds.");
    }

    @Test
    void shouldThrowErrorForBrowserTimeout() throws InterruptedException {
        Thread provideCredentialsThread = new Thread(() -> this.authTestHelper.provideCredentials("timeout", this.login, this.password));
        Thread connectThread = this.authTestHelper.getConnectAndExecuteSimpleQueryThread(this.properties, "BROWSER_RESPONSE_TIMEOUT=1");
        this.authTestHelper.connectAndProvideCredentials(provideCredentialsThread, connectThread);
        this.authTestHelper.verifyExceptionIsThrown("JDBC driver encountered communication error. Message: External browser authentication failed within timeout of 1000 milliseconds.");
    }
}

