/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.authentication;

import net.snowflake.client.authentication.AuthConnectionParameters;
import net.snowflake.client.authentication.AuthTestHelper;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;

@Tag(value="authentication")
@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
class IdTokenLatestIT {
    String login = AuthConnectionParameters.SSO_USER;
    String password = AuthConnectionParameters.SSO_PASSWORD;
    AuthTestHelper authTestHelper = new AuthTestHelper();
    private static String firstToken;

    IdTokenLatestIT() {
    }

    @BeforeAll
    public static void globalSetUp() {
        AuthTestHelper.deleteIdToken();
    }

    @AfterEach
    public void tearDown() {
        this.authTestHelper.cleanBrowserProcesses();
    }

    @Test
    @Order(value=1)
    void shouldAuthenticateUsingExternalBrowserAndSaveToken() throws InterruptedException {
        Thread provideCredentialsThread = new Thread(() -> this.authTestHelper.provideCredentials("success", this.login, this.password));
        Thread connectThread = this.authTestHelper.getConnectAndExecuteSimpleQueryThread(AuthConnectionParameters.getStoreIDTokenConnectionParameters());
        this.authTestHelper.connectAndProvideCredentials(provideCredentialsThread, connectThread);
        this.authTestHelper.verifyExceptionIsNotThrown();
        firstToken = this.authTestHelper.getIdToken();
        MatcherAssert.assertThat((String)"Id token was not saved", (Object)firstToken, (Matcher)Matchers.notNullValue());
    }

    @Test
    @Order(value=2)
    void shouldAuthenticateUsingTokenWithoutBrowser() {
        this.verifyFirstTokenWasSaved();
        this.authTestHelper.connectAndExecuteSimpleQuery(AuthConnectionParameters.getStoreIDTokenConnectionParameters(), null);
        this.authTestHelper.verifyExceptionIsNotThrown();
    }

    @Test
    @Order(value=3)
    void shouldOpenBrowserAgainWhenTokenIsDeleted() throws InterruptedException {
        this.verifyFirstTokenWasSaved();
        AuthTestHelper.deleteIdToken();
        Thread provideCredentialsThread = new Thread(() -> this.authTestHelper.provideCredentials("success", this.login, this.password));
        Thread connectThread = this.authTestHelper.getConnectAndExecuteSimpleQueryThread(AuthConnectionParameters.getStoreIDTokenConnectionParameters());
        this.authTestHelper.connectAndProvideCredentials(provideCredentialsThread, connectThread);
        this.authTestHelper.verifyExceptionIsNotThrown();
        String secondToken = this.authTestHelper.getIdToken();
        MatcherAssert.assertThat((String)"Id token was not saved", (Object)secondToken, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"Id token was not updated", (Object)secondToken, (Matcher)Matchers.not((Object)firstToken));
    }

    private void verifyFirstTokenWasSaved() {
        Assumptions.assumeTrue((firstToken != null ? 1 : 0) != 0, (String)"token was not saved, skipping test");
    }
}

