/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.authentication;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.snowflake.client.authentication.AuthConnectionParameters;
import net.snowflake.client.authentication.AuthTestHelper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="authentication")
public class OauthLatestIT {
    AuthTestHelper authTestHelper;

    @BeforeEach
    public void setUp() throws IOException {
        this.authTestHelper = new AuthTestHelper();
    }

    @Test
    void shouldAuthenticateUsingOauth() throws IOException {
        this.authTestHelper.connectAndExecuteSimpleQuery(AuthConnectionParameters.getOauthConnectionParameters(this.getToken()), null);
        this.authTestHelper.verifyExceptionIsNotThrown();
    }

    @Test
    void shouldThrowErrorForInvalidToken() {
        this.authTestHelper.connectAndExecuteSimpleQuery(AuthConnectionParameters.getOauthConnectionParameters("invalidToken"), null);
        this.authTestHelper.verifyExceptionIsThrown("Invalid OAuth access token. ");
    }

    @Test
    void shouldThrowErrorForMismatchedOauthUsername() throws IOException {
        Properties properties = AuthConnectionParameters.getOauthConnectionParameters(this.getToken());
        properties.put("user", "differentUsername");
        this.authTestHelper.connectAndExecuteSimpleQuery(properties, null);
        this.authTestHelper.verifyExceptionIsThrown("The user you were trying to authenticate as differs from the user tied to the access token.");
    }

    private String getToken() throws IOException {
        JsonNode jsonNode;
        List data = Stream.of("username=" + System.getenv("SNOWFLAKE_AUTH_TEST_OKTA_USER"), "password=" + System.getenv("SNOWFLAKE_AUTH_TEST_OKTA_PASS"), "grant_type=password", "scope=session:role:" + System.getenv("SNOWFLAKE_AUTH_TEST_ROLE").toLowerCase()).collect(Collectors.toList());
        String auth = System.getenv("SNOWFLAKE_AUTH_TEST_OAUTH_CLIENT_ID") + ":" + System.getenv("SNOWFLAKE_AUTH_TEST_OAUTH_CLIENT_SECRET");
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
        URL url = new URL(System.getenv("SNOWFLAKE_AUTH_TEST_OAUTH_URL"));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
        connection.setDoOutput(true);
        try (DataOutputStream out = new DataOutputStream(connection.getOutputStream());){
            out.writeBytes(String.join((CharSequence)"&", data));
            out.flush();
        }
        int responseCode = connection.getResponseCode();
        MatcherAssert.assertThat((String)("Failed to get access token, response code: " + responseCode), (Object)responseCode, (Matcher)CoreMatchers.is((Object)200));
        ObjectMapper mapper = new ObjectMapper();
        try (InputStream inputStream = connection.getInputStream();){
            jsonNode = mapper.readTree(inputStream);
        }
        return jsonNode.get("access_token").asText();
    }
}

