/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.authentication;

import java.io.IOException;
import java.util.Properties;
import net.snowflake.client.authentication.AuthConnectionParameters;
import net.snowflake.client.authentication.AuthTestHelper;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="authentication")
public class OauthOktaAuthorizationCodeLatestIT {
    String login = AuthConnectionParameters.SSO_USER;
    String password = AuthConnectionParameters.SSO_PASSWORD;
    AuthTestHelper authTestHelper = new AuthTestHelper();
    Properties properties;

    @BeforeEach
    public void setUp() throws IOException {
        AuthTestHelper.deleteIdToken();
        AuthTestHelper.deleteOauthToken();
        this.properties = AuthConnectionParameters.getOAuthExternalAuthorizationCodeConnectionParameters();
    }

    @AfterEach
    public void cleanUp() {
        this.authTestHelper.cleanBrowserProcesses();
    }

    @AfterAll
    public static void tearDown() {
        AuthTestHelper.deleteIdToken();
        AuthTestHelper.deleteOauthToken();
    }

    @Test
    void shouldAuthenticateUsingExternalOauthOktaAuthorizationCode() throws InterruptedException {
        Thread provideCredentialsThread = new Thread(() -> this.authTestHelper.provideCredentials("externalOauthOktaSuccess", this.login, this.password));
        Thread connectThread = new Thread(() -> this.authTestHelper.connectAndExecuteSimpleQuery(this.properties, null));
        this.authTestHelper.connectAndProvideCredentials(provideCredentialsThread, connectThread);
        this.authTestHelper.verifyExceptionIsNotThrown();
    }

    @Test
    void shouldThrowErrorForMismatchedOauthOktaUsername() throws InterruptedException {
        this.properties.setProperty("user", "invalidUser@snowflake.com");
        Thread provideCredentialsThread = new Thread(() -> this.authTestHelper.provideCredentials("externalOauthOktaSuccess", this.login, this.password));
        Thread connectThread = this.authTestHelper.getConnectAndExecuteSimpleQueryThread(this.properties, null);
        this.authTestHelper.connectAndProvideCredentials(provideCredentialsThread, connectThread);
        this.authTestHelper.verifyExceptionIsThrown("The user you were trying to authenticate as differs from the user tied to the access token.");
    }

    @Test
    void shouldThrowErrorForOauthOktaTimeout() throws InterruptedException {
        this.properties.put("BROWSER_RESPONSE_TIMEOUT", "0");
        this.authTestHelper.connectAndExecuteSimpleQuery(this.properties, null);
        this.authTestHelper.verifyExceptionIsThrown("Error during OAuth Authorization Code authentication: Authorization request timed out. Snowflake driver did not receive authorization code back to the redirect URI. Verify your security integration and driver configuration.");
    }

    @Test
    void shouldAuthenticateUsingTokenCacheForOauthOkta() throws InterruptedException {
        this.properties.put("CLIENT_STORE_TEMPORARY_CREDENTIAL", (Object)true);
        Thread provideCredentialsThread = new Thread(() -> this.authTestHelper.provideCredentials("externalOauthOktaSuccess", this.login, this.password));
        Thread connectThread = this.authTestHelper.getConnectAndExecuteSimpleQueryThread(this.properties, null);
        this.authTestHelper.connectAndProvideCredentials(provideCredentialsThread, connectThread);
        this.authTestHelper.verifyExceptionIsNotThrown();
        this.authTestHelper.connectAndExecuteSimpleQuery(this.properties, null);
        this.authTestHelper.verifyExceptionIsNotThrown();
    }
}

