/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.authentication;

import java.io.IOException;
import java.util.Properties;
import net.snowflake.client.authentication.AuthConnectionParameters;
import net.snowflake.client.authentication.AuthTestHelper;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="authentication")
public class OauthSnowflakeAuthorizationCodeLatestIT {
    Properties properties = AuthConnectionParameters.getOAuthSnowflakeAuthorizationCodeConnectionParameters();
    String login = this.properties.getProperty("user");
    String password = AuthConnectionParameters.OAUTH_PASSWORD;
    AuthTestHelper authTestHelper = new AuthTestHelper();

    @BeforeEach
    public void setUp() throws IOException {
        this.authTestHelper.cleanBrowserProcesses();
        AuthTestHelper.deleteIdToken(AuthConnectionParameters.HOST, this.login);
        AuthTestHelper.deleteOauthToken(AuthConnectionParameters.HOST, this.login);
        AuthTestHelper.deleteOauthRefreshToken(AuthConnectionParameters.HOST, this.login);
        this.properties = AuthConnectionParameters.getOAuthSnowflakeAuthorizationCodeConnectionParameters();
    }

    @AfterEach
    public void cleanUp() {
        this.authTestHelper.cleanBrowserProcesses();
    }

    @AfterAll
    public static void tearDown() {
        Properties properties = AuthConnectionParameters.getOAuthSnowflakeAuthorizationCodeConnectionParameters();
        AuthTestHelper.deleteIdToken(AuthConnectionParameters.HOST, properties.getProperty("user"));
        AuthTestHelper.deleteOauthToken(AuthConnectionParameters.HOST, properties.getProperty("user"));
        AuthTestHelper.deleteOauthRefreshToken(AuthConnectionParameters.HOST, properties.getProperty("user"));
    }

    @Test
    void shouldAuthenticateUsingSnowflakeOauthAuthorizationCode() throws InterruptedException {
        Thread provideCredentialsThread = new Thread(() -> this.authTestHelper.provideCredentials("internalOauthSnowflakeSuccess", this.login, this.password));
        Thread connectThread = new Thread(() -> this.authTestHelper.connectAndExecuteSimpleQuery(this.properties, null));
        this.authTestHelper.connectAndProvideCredentials(provideCredentialsThread, connectThread);
        this.authTestHelper.verifyExceptionIsNotThrown();
    }

    @Test
    void shouldThrowErrorForMismatchedOauthSnowflakeUsername() throws InterruptedException {
        this.properties.setProperty("user", "invalidUser@snowflake.com");
        Thread provideCredentialsThread = new Thread(() -> this.authTestHelper.provideCredentials("internalOauthSnowflakeSuccess", this.login, this.password));
        Thread connectThread = new Thread(() -> this.authTestHelper.connectAndExecuteSimpleQuery(this.properties, null));
        this.authTestHelper.connectAndProvideCredentials(provideCredentialsThread, connectThread);
        this.authTestHelper.verifyExceptionIsThrown("The user you were trying to authenticate as differs from the user tied to the access token.");
    }

    @Test
    void shouldThrowErrorForOauthSnowflakeTimeout() throws InterruptedException {
        this.properties.put("BROWSER_RESPONSE_TIMEOUT", "0");
        this.authTestHelper.connectAndExecuteSimpleQuery(this.properties, null);
        this.authTestHelper.verifyExceptionIsThrown("Error during OAuth Authorization Code authentication: Authorization request timed out. Snowflake driver did not receive authorization code back to the redirect URI. Verify your security integration and driver configuration.");
    }

    @Test
    void shouldAuthenticateUsingTokenCacheOauthSnowflake() throws InterruptedException {
        this.properties.put("CLIENT_STORE_TEMPORARY_CREDENTIAL", (Object)true);
        Thread provideCredentialsThread = new Thread(() -> this.authTestHelper.provideCredentials("internalOauthSnowflakeSuccess", this.login, this.password));
        Thread connectThread = this.authTestHelper.getConnectAndExecuteSimpleQueryThread(this.properties, null);
        this.authTestHelper.connectAndProvideCredentials(provideCredentialsThread, connectThread);
        this.authTestHelper.verifyExceptionIsNotThrown();
        this.authTestHelper.connectAndExecuteSimpleQuery(this.properties, null);
        this.authTestHelper.verifyExceptionIsNotThrown();
    }

    @Test
    void shouldNotAuthenticateUsingTokenCacheOauthSnowflake() throws InterruptedException {
        this.properties.put("CLIENT_STORE_TEMPORARY_CREDENTIAL", (Object)true);
        this.properties.remove("user");
        Thread provideCredentialsThread = new Thread(() -> this.authTestHelper.provideCredentials("internalOauthSnowflakeSuccess", this.login, this.password));
        Thread connectThread = this.authTestHelper.getConnectAndExecuteSimpleQueryThread(this.properties, null);
        this.authTestHelper.connectAndProvideCredentials(provideCredentialsThread, connectThread);
        this.authTestHelper.verifyExceptionIsNotThrown();
        this.properties.put("BROWSER_RESPONSE_TIMEOUT", "5");
        this.authTestHelper.connectAndExecuteSimpleQuery(this.properties, null);
        this.authTestHelper.verifyExceptionIsThrown("Error during OAuth Authorization Code authentication: Authorization request timed out. Snowflake driver did not receive authorization code back to the redirect URI. Verify your security integration and driver configuration.");
    }
}

