/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.authentication;

import java.io.IOException;
import java.util.Properties;
import net.snowflake.client.authentication.AuthConnectionParameters;
import net.snowflake.client.authentication.AuthTestHelper;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="authentication")
public class OauthSnowflakeClientCredentialsLatestIT {
    Properties properties = AuthConnectionParameters.getOAuthSnowflakeClientCredentialParameters();
    String login = this.properties.getProperty("user");
    AuthTestHelper authTestHelper = new AuthTestHelper();

    @BeforeEach
    public void setUp() throws IOException {
        AuthTestHelper.deleteIdToken(AuthConnectionParameters.HOST, this.login);
        AuthTestHelper.deleteOauthToken(AuthConnectionParameters.OKTA, this.login);
        this.properties = AuthConnectionParameters.getOAuthSnowflakeClientCredentialParameters();
    }

    @AfterAll
    public static void tearDown() {
        Properties properties = AuthConnectionParameters.getOAuthSnowflakeClientCredentialParameters();
        AuthTestHelper.deleteIdToken(AuthConnectionParameters.HOST, properties.getProperty("user"));
        AuthTestHelper.deleteOauthToken(AuthConnectionParameters.OKTA, properties.getProperty("user"));
    }

    @Test
    void shouldAuthenticateUsingSnowflakeOauthClientCredentials() {
        this.authTestHelper.connectAndExecuteSimpleQuery(this.properties, null);
        this.authTestHelper.verifyExceptionIsNotThrown();
    }

    @Test
    void shouldThrowErrorForClientCredentialsMismatchedUsername() throws InterruptedException {
        this.properties.put("user", "invalidUser@snowflake.com");
        this.authTestHelper.connectAndExecuteSimpleQuery(this.properties, null);
        this.authTestHelper.verifyExceptionIsThrown("The user you were trying to authenticate as differs from the user tied to the access token.");
    }

    @Test
    void shouldThrowErrorForUnauthorizedClientCredentials() throws InterruptedException, SnowflakeSQLException {
        this.properties.put("oauthClientId", "invalidClientId");
        this.authTestHelper.connectAndExecuteSimpleQuery(this.properties, null);
        this.authTestHelper.verifyExceptionIsThrown("Error during OAuth Client Credentials authentication: JDBC driver encountered communication error. Message: HTTP status=401.");
    }
}

