/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.snowflake.client.config.SFClientConfig;
import net.snowflake.client.config.SFClientConfigParser;
import net.snowflake.client.jdbc.SnowflakeUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class SFClientConfigParserTest {
    private static final String CONFIG_JSON = "{\"common\":{\"log_level\":\"info\",\"log_path\":\"/jdbc.log\"}}";
    private static final String CONFIG_JSON_WITH_UNKNOWN_PROPS = "{\"common\":{\"log_level\":\"info\",\"log_path\":\"/jdbc.log\",\"unknown_inside\":\"/unknown\"},\"unknown_outside\":\"/unknown\"}";
    private Path configFilePath;

    @AfterEach
    public void cleanup() throws IOException {
        if (this.configFilePath != null) {
            Files.deleteIfExists(this.configFilePath);
        }
        SnowflakeUtil.systemUnsetEnv((String)"SF_CLIENT_CONFIG_FILE");
    }

    @Test
    public void testLoadSFClientConfigValidPath() throws IOException {
        this.configFilePath = Paths.get("config.json", new String[0]);
        Files.write(this.configFilePath, CONFIG_JSON.getBytes(), new OpenOption[0]);
        SFClientConfig actualConfig = SFClientConfigParser.loadSFClientConfig((String)this.configFilePath.toString());
        Assertions.assertEquals((Object)"info", (Object)actualConfig.getCommonProps().getLogLevel());
        Assertions.assertEquals((Object)"/jdbc.log", (Object)actualConfig.getCommonProps().getLogPath());
        Assertions.assertEquals((Object)"config.json", (Object)actualConfig.getConfigFilePath());
    }

    @Test
    public void testLoadSFClientConfigValidPathWithUnknownProperties() throws IOException {
        this.configFilePath = Paths.get("config.json", new String[0]);
        Files.write(this.configFilePath, CONFIG_JSON_WITH_UNKNOWN_PROPS.getBytes(), new OpenOption[0]);
        SFClientConfig actualConfig = SFClientConfigParser.loadSFClientConfig((String)this.configFilePath.toString());
        Assertions.assertEquals((Object)"info", (Object)actualConfig.getCommonProps().getLogLevel());
        Assertions.assertEquals((Object)"/jdbc.log", (Object)actualConfig.getCommonProps().getLogPath());
    }

    @Test
    public void testLoadSFClientConfigInValidPath() {
        String configFilePath = "InvalidPath";
        Assertions.assertThrows(IOException.class, () -> SFClientConfigParser.loadSFClientConfig((String)configFilePath));
    }

    @Test
    public void testLoadSFClientConfigInValidJson() {
        Assertions.assertThrows(IOException.class, () -> {
            String invalidJson = "invalidJson";
            this.configFilePath = Paths.get("config.json", new String[0]);
            Files.write(this.configFilePath, invalidJson.getBytes(), new OpenOption[0]);
            SFClientConfigParser.loadSFClientConfig((String)this.configFilePath.toString());
        });
    }

    @Test
    public void testLoadSFClientConfigWithEnvVar() throws IOException {
        this.configFilePath = Paths.get("config.json", new String[0]);
        Files.write(this.configFilePath, CONFIG_JSON.getBytes(), new OpenOption[0]);
        SnowflakeUtil.systemSetEnv((String)"SF_CLIENT_CONFIG_FILE", (String)"config.json");
        SFClientConfig actualConfig = SFClientConfigParser.loadSFClientConfig(null);
        Assertions.assertEquals((Object)"info", (Object)actualConfig.getCommonProps().getLogLevel());
        Assertions.assertEquals((Object)"/jdbc.log", (Object)actualConfig.getCommonProps().getLogPath());
    }

    @Test
    public void testLoadSFClientConfigWithDriverLocation() throws IOException {
        String configLocation = Paths.get(SFClientConfigParser.getConfigFilePathFromJDBCJarLocation(), "sf_client_config.json").toString();
        this.configFilePath = Paths.get(configLocation, new String[0]);
        Files.write(this.configFilePath, CONFIG_JSON.getBytes(), new OpenOption[0]);
        SFClientConfig actualConfig = SFClientConfigParser.loadSFClientConfig(null);
        Assertions.assertEquals((Object)"info", (Object)actualConfig.getCommonProps().getLogLevel());
        Assertions.assertEquals((Object)"/jdbc.log", (Object)actualConfig.getCommonProps().getLogPath());
    }

    @Test
    public void testLoadSFClientConfigWithUserHome() throws IOException {
        String tmpDirectory = SnowflakeUtil.systemGetProperty((String)"java.io.tmpdir");
        try (MockedStatic mockedSnowflakeUtil = Mockito.mockStatic(SnowflakeUtil.class);){
            mockedSnowflakeUtil.when(() -> SnowflakeUtil.systemGetProperty((String)"user.home")).thenReturn((Object)tmpDirectory);
            this.configFilePath = Paths.get(SnowflakeUtil.systemGetProperty((String)"user.home"), "sf_client_config.json");
            Files.write(this.configFilePath, CONFIG_JSON.getBytes(), new OpenOption[0]);
            SFClientConfig actualConfig = SFClientConfigParser.loadSFClientConfig(null);
            Assertions.assertEquals((Object)"info", (Object)actualConfig.getCommonProps().getLogLevel());
            Assertions.assertEquals((Object)"/jdbc.log", (Object)actualConfig.getCommonProps().getLogPath());
        }
    }

    @Test
    public void testLoadSFClientNoConditionsMatch() throws IOException {
        SFClientConfig actualConfig = SFClientConfigParser.loadSFClientConfig(null);
        Assertions.assertNull((Object)actualConfig);
    }

    @Test
    public void testGetConfigFileNameFromJDBCJarLocation() {
        String jdbcDirectoryPath = SFClientConfigParser.getConfigFilePathFromJDBCJarLocation();
        Assertions.assertTrue((jdbcDirectoryPath != null && !jdbcDirectoryPath.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testConvertToWindowsPath() {
        String mockWindowsPath = "C:/Program Files/example.txt";
        String resultWindowsPath = "C:\\Program Files\\example.txt";
        String[] testCases = new String[]{"", "file:\\", "\\\\", "/", "nested:\\"};
        String mockCloudPrefix = "cloud://";
        for (String testcase : testCases) {
            Assertions.assertEquals((Object)resultWindowsPath, (Object)SFClientConfigParser.convertToWindowsPath((String)(testcase + mockWindowsPath)));
        }
        Assertions.assertEquals((Object)(mockCloudPrefix + resultWindowsPath), (Object)SFClientConfigParser.convertToWindowsPath((String)(mockCloudPrefix + mockWindowsPath)));
    }
}

