/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.config;

import com.fasterxml.jackson.dataformat.toml.TomlMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.snowflake.client.AssumptionUtils;
import net.snowflake.client.config.ConnectionParameters;
import net.snowflake.client.config.SFConnectionConfigParser;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SFConnectionConfigParserTest {
    private static final List<String> ENV_VARIABLES_KEYS = new ArrayList<String>(Arrays.asList("SNOWFLAKE_HOME", "SNOWFLAKE_DEFAULT_CONNECTION_NAME", "SKIP_TOKEN_FILE_PERMISSIONS_VERIFICATION"));
    private Path tempPath = null;
    private TomlMapper tomlMapper = new TomlMapper();
    private Map<String, String> envVariables = new HashMap<String, String>();

    @BeforeEach
    public void setUp() throws IOException {
        this.tempPath = Files.createTempDirectory(".snowflake", new FileAttribute[0]);
        ENV_VARIABLES_KEYS.stream().forEach(key -> {
            if (SnowflakeUtil.systemGetEnv((String)key) != null) {
                this.envVariables.put((String)key, SnowflakeUtil.systemGetEnv((String)key));
            }
        });
    }

    @AfterEach
    public void close() throws IOException {
        SnowflakeUtil.systemUnsetEnv((String)"SNOWFLAKE_HOME");
        SnowflakeUtil.systemUnsetEnv((String)"SNOWFLAKE_DEFAULT_CONNECTION_NAME");
        SnowflakeUtil.systemUnsetEnv((String)"SKIP_TOKEN_FILE_PERMISSIONS_VERIFICATION");
        Files.walk(this.tempPath, new FileVisitOption[0]).map(Path::toFile).forEach(File::delete);
        Files.delete(this.tempPath);
        this.envVariables.forEach((key, value) -> SnowflakeUtil.systemSetEnv((String)key, (String)value));
    }

    @Test
    public void testLoadSFConnectionConfigWrongConfigurationName() throws SnowflakeSQLException, IOException {
        SnowflakeUtil.systemSetEnv((String)"SNOWFLAKE_HOME", (String)this.tempPath.toString());
        SnowflakeUtil.systemSetEnv((String)"SNOWFLAKE_DEFAULT_CONNECTION_NAME", (String)"unknown");
        this.prepareConnectionConfigurationTomlFile();
        ConnectionParameters connectionParameters = SFConnectionConfigParser.buildConnectionParameters();
        Assertions.assertNull((Object)connectionParameters);
    }

    @Test
    public void testLoadSFConnectionConfigInValidPath() throws SnowflakeSQLException, IOException {
        SnowflakeUtil.systemSetEnv((String)"SNOWFLAKE_HOME", (String)Paths.get("unknownPath", new String[0]).toString());
        this.prepareConnectionConfigurationTomlFile();
        Assertions.assertNull((Object)SFConnectionConfigParser.buildConnectionParameters());
    }

    @Test
    public void testLoadSFConnectionConfigWithTokenFromFile() throws SnowflakeSQLException, IOException {
        SnowflakeUtil.systemSetEnv((String)"SNOWFLAKE_HOME", (String)this.tempPath.toString());
        SnowflakeUtil.systemSetEnv((String)"SNOWFLAKE_DEFAULT_CONNECTION_NAME", (String)"default");
        File tokenFile = new File(Paths.get(this.tempPath.toString(), "token").toUri());
        this.prepareConnectionConfigurationTomlFile(Collections.singletonMap("token_file_path", tokenFile.toString()));
        ConnectionParameters data = SFConnectionConfigParser.buildConnectionParameters();
        Assertions.assertNotNull((Object)data);
        Assertions.assertEquals((Object)tokenFile.toString(), (Object)data.getParams().get("token_file_path"));
    }

    @Test
    public void testThrowErrorWhenWrongPermissionsForConnectionConfigurationFile() throws IOException {
        SnowflakeUtil.systemSetEnv((String)"SNOWFLAKE_HOME", (String)this.tempPath.toString());
        File tokenFile = new File(Paths.get(this.tempPath.toString(), "token").toUri());
        this.prepareConnectionConfigurationTomlFile(Collections.singletonMap("token_file_path", tokenFile.toString()), false, false);
        AssumptionUtils.assumeRunningOnLinuxMac();
        Assertions.assertThrows(SnowflakeSQLException.class, () -> SFConnectionConfigParser.buildConnectionParameters());
    }

    @Test
    public void testThrowErrorWhenWrongPermissionsForTokenFile() throws IOException {
        SnowflakeUtil.systemSetEnv((String)"SNOWFLAKE_HOME", (String)this.tempPath.toString());
        File tokenFile = new File(Paths.get(this.tempPath.toString(), "token").toUri());
        this.prepareConnectionConfigurationTomlFile(Collections.singletonMap("token_file_path", tokenFile.toString()), true, false);
        AssumptionUtils.assumeRunningOnLinuxMac();
        Assertions.assertThrows(SnowflakeSQLException.class, () -> SFConnectionConfigParser.buildConnectionParameters());
    }

    @Test
    public void testNoThrowErrorWhenWrongPermissionsForTokenFileButSkippingFlagIsEnabled() throws SnowflakeSQLException, IOException {
        SnowflakeUtil.systemSetEnv((String)"SNOWFLAKE_HOME", (String)this.tempPath.toString());
        SnowflakeUtil.systemSetEnv((String)"SNOWFLAKE_DEFAULT_CONNECTION_NAME", (String)"default");
        SnowflakeUtil.systemSetEnv((String)"SKIP_TOKEN_FILE_PERMISSIONS_VERIFICATION", (String)"true");
        File tokenFile = new File(Paths.get(this.tempPath.toString(), "token").toUri());
        this.prepareConnectionConfigurationTomlFile(Collections.singletonMap("token_file_path", tokenFile.toString()), true, false);
        ConnectionParameters data = SFConnectionConfigParser.buildConnectionParameters();
        Assertions.assertNotNull((Object)data);
        Assertions.assertEquals((Object)tokenFile.toString(), (Object)data.getParams().get("token_file_path"));
    }

    @Test
    public void testLoadSFConnectionConfigWithHostConfigured() throws SnowflakeSQLException, IOException {
        SnowflakeUtil.systemSetEnv((String)"SNOWFLAKE_HOME", (String)this.tempPath.toString());
        SnowflakeUtil.systemSetEnv((String)"SNOWFLAKE_DEFAULT_CONNECTION_NAME", (String)"default");
        HashMap<String, String> extraparams = new HashMap<String, String>();
        extraparams.put("host", "snowflake.reg.local");
        extraparams.put("account", null);
        extraparams.put("port", "8082");
        extraparams.put("token", "testToken");
        this.prepareConnectionConfigurationTomlFile(extraparams);
        ConnectionParameters data = SFConnectionConfigParser.buildConnectionParameters();
        Assertions.assertNotNull((Object)data);
        Assertions.assertEquals((Object)"jdbc:snowflake://snowflake.reg.local:8082", (Object)data.getUrl());
        Assertions.assertEquals((Object)"oauth", (Object)data.getParams().get("authenticator"));
        Assertions.assertEquals((Object)"testToken", (Object)data.getParams().get("token"));
    }

    @Test
    public void shouldThrowExceptionIfNoneOfHostAndAccountIsSet() throws IOException {
        SnowflakeUtil.systemSetEnv((String)"SNOWFLAKE_HOME", (String)this.tempPath.toString());
        SnowflakeUtil.systemSetEnv((String)"SNOWFLAKE_DEFAULT_CONNECTION_NAME", (String)"default");
        HashMap<String, Object> extraparams = new HashMap<String, Object>();
        extraparams.put("host", null);
        extraparams.put("account", null);
        this.prepareConnectionConfigurationTomlFile(extraparams);
        Assertions.assertThrows(SnowflakeSQLException.class, () -> SFConnectionConfigParser.buildConnectionParameters());
    }

    @Test
    public void shouldThrowExceptionIfTokenIsNotSetForOauth() throws IOException {
        SnowflakeUtil.systemSetEnv((String)"SNOWFLAKE_HOME", (String)this.tempPath.toString());
        SnowflakeUtil.systemSetEnv((String)"SNOWFLAKE_DEFAULT_CONNECTION_NAME", (String)"default");
        SnowflakeUtil.systemSetEnv((String)"SKIP_TOKEN_FILE_PERMISSIONS_VERIFICATION", (String)"true");
        File tokenFile = new File(Paths.get(this.tempPath.toString(), "token").toUri());
        this.prepareConnectionConfigurationTomlFile(Collections.singletonMap("token_file_path", tokenFile.toString()), true, false, "");
        Assertions.assertThrows(SnowflakeSQLException.class, () -> SFConnectionConfigParser.buildConnectionParameters());
    }

    private void prepareConnectionConfigurationTomlFile() throws IOException {
        this.prepareConnectionConfigurationTomlFile(null, true, true);
    }

    private void prepareConnectionConfigurationTomlFile(Map moreParameters) throws IOException {
        this.prepareConnectionConfigurationTomlFile(moreParameters, true, true);
    }

    private void prepareConnectionConfigurationTomlFile(Map moreParameters, boolean onlyUserPermissionConnection, boolean onlyUserPermissionToken) throws IOException {
        this.prepareConnectionConfigurationTomlFile(moreParameters, onlyUserPermissionConnection, onlyUserPermissionToken, "token_from_file");
    }

    private void prepareConnectionConfigurationTomlFile(Map moreParameters, boolean onlyUserPermissionConnection, boolean onlyUserPermissionToken, String token) throws IOException {
        Path path = Paths.get(this.tempPath.toString(), "connections.toml");
        Path filePath = this.createFilePathWithPermission(path, onlyUserPermissionConnection);
        File file = filePath.toFile();
        HashMap configuration = new HashMap();
        HashMap<String, String> configurationParams = new HashMap<String, String>();
        configurationParams.put("account", "snowaccount.us-west-2.aws");
        configurationParams.put("user", "user1");
        configurationParams.put("port", "443");
        configurationParams.put("authenticator", "oauth");
        if (moreParameters != null) {
            moreParameters.forEach((k, v) -> configurationParams.put((String)k, (String)v));
        }
        configuration.put("default", configurationParams);
        this.tomlMapper.writeValue(file, configuration);
        if (configurationParams.containsKey("token_file_path")) {
            Path tokenFilePath = this.createFilePathWithPermission(Paths.get(configurationParams.get("token_file_path").toString(), new String[0]), onlyUserPermissionToken);
            Files.write(tokenFilePath, token.getBytes(), new OpenOption[0]);
            Path emptyTokenFilePath = this.createFilePathWithPermission(Paths.get(configurationParams.get("token_file_path").toString().replaceAll("token", "emptytoken"), new String[0]), onlyUserPermissionToken);
            Files.write(emptyTokenFilePath, "".getBytes(), new OpenOption[0]);
        }
    }

    private Path createFilePathWithPermission(Path path, boolean onlyUserPermission) throws IOException {
        if (!SnowflakeUtil.isWindows()) {
            FileAttribute<Set<PosixFilePermission>> fileAttribute = onlyUserPermission ? PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-------")) : PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxrw----"));
            return Files.createFile(path, fileAttribute);
        }
        return Files.createFile(path, new FileAttribute[0]);
    }
}

