/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import net.snowflake.client.core.CachedCredentialType;
import net.snowflake.client.core.CredentialManager;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SFOauthLoginInput;
import net.snowflake.client.core.SecureStorageManager;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class CredentialManagerTest {
    public static final String SNOWFLAKE_HOST = "some-account.us-west-2.aws.snowflakecomputing.com";
    public static final String EXTERNAL_OAUTH_HOST = "some-external-oauth-host.com";
    public static final String SOME_ACCESS_TOKEN = "some-oauth-access-token";
    public static final String SOME_REFRESH_TOKEN = "some-refresh-token";
    public static final String SOME_ID_TOKEN_FROM_CACHE = "some-id-token";
    public static final String SOME_MFA_TOKEN_FROM_CACHE = "some-mfa-token";
    public static final String SOME_DPOP_PUBLIC_KEY = "{\"kty\":\"EC\",\"d\":\"j5-J-nLE4J1I8ZWtArP8eQbxUbYMPmRvaEjEkHFlHds\",\"crv\":\"P-256\",\"x\":\"RL5cE-TC4Jr6CxtT4lEI2Yu6wT6LbwojPQsgHUg01F0\",\"y\":\"UAdLUSWTJ6czXaS3SfEFUZzKPcVVq4OZAD8e7Rp75y4\"}";
    public static final String SOME_USER = "some-user";
    public static final String ACCESS_TOKEN_FROM_CACHE = "access-token-from-cache";
    public static final String REFRESH_TOKEN_FROM_CACHE = "refresh-token-from-cache";
    public static final String EXTERNAL_ACCESS_TOKEN_FROM_CACHE = "external-access-token-from-cache";
    public static final String EXTERNAL_REFRESH_TOKEN_FROM_CACHE = "external-refresh-token-from-cache";
    private static final SecureStorageManager mockSecureStorageManager = (SecureStorageManager)Mockito.mock(SecureStorageManager.class);

    CredentialManagerTest() {
    }

    @BeforeAll
    public static void setUp() {
        CredentialManager.injectSecureStorageManager((SecureStorageManager)mockSecureStorageManager);
    }

    @AfterAll
    public static void tearDown() {
        CredentialManager.resetSecureStorageManager();
    }

    @Test
    public void shouldCreateHostBasedOnExternalIdpUrl() throws SFException {
        SFLoginInput loginInput = this.createLoginInputWithExternalOAuth();
        String host = CredentialManager.getHostForOAuthCacheKey((SFLoginInput)loginInput);
        Assertions.assertEquals((Object)EXTERNAL_OAUTH_HOST, (Object)host);
    }

    @Test
    public void shouldCreateHostBasedOnSnowflakeServerUrl() throws SFException {
        SFLoginInput loginInput = this.createLoginInputWithSnowflakeServer();
        String host = CredentialManager.getHostForOAuthCacheKey((SFLoginInput)loginInput);
        Assertions.assertEquals((Object)SNOWFLAKE_HOST, (Object)host);
    }

    @Test
    public void shouldProperlyWriteTokensToCache() throws SFException {
        Base64.Encoder encoder = Base64.getEncoder();
        SFLoginInput loginInputSnowflakeOAuth = this.createLoginInputWithSnowflakeServer();
        CredentialManager.writeIdToken((SFLoginInput)loginInputSnowflakeOAuth, (String)SOME_ID_TOKEN_FROM_CACHE);
        ((SecureStorageManager)Mockito.verify((Object)mockSecureStorageManager, (VerificationMode)Mockito.times((int)1))).setCredential(SNOWFLAKE_HOST, SOME_USER, CachedCredentialType.ID_TOKEN.getValue(), encoder.encodeToString(SOME_ID_TOKEN_FROM_CACHE.getBytes(StandardCharsets.UTF_8)));
        CredentialManager.writeMfaToken((SFLoginInput)loginInputSnowflakeOAuth, (String)SOME_MFA_TOKEN_FROM_CACHE);
        ((SecureStorageManager)Mockito.verify((Object)mockSecureStorageManager, (VerificationMode)Mockito.times((int)1))).setCredential(SNOWFLAKE_HOST, SOME_USER, CachedCredentialType.MFA_TOKEN.getValue(), encoder.encodeToString(SOME_MFA_TOKEN_FROM_CACHE.getBytes(StandardCharsets.UTF_8)));
        CredentialManager.writeOAuthAccessToken((SFLoginInput)loginInputSnowflakeOAuth);
        ((SecureStorageManager)Mockito.verify((Object)mockSecureStorageManager, (VerificationMode)Mockito.times((int)1))).setCredential(SNOWFLAKE_HOST, SOME_USER, CachedCredentialType.OAUTH_ACCESS_TOKEN.getValue(), encoder.encodeToString(SOME_ACCESS_TOKEN.getBytes(StandardCharsets.UTF_8)));
        CredentialManager.writeOAuthRefreshToken((SFLoginInput)loginInputSnowflakeOAuth);
        ((SecureStorageManager)Mockito.verify((Object)mockSecureStorageManager, (VerificationMode)Mockito.times((int)1))).setCredential(SNOWFLAKE_HOST, SOME_USER, CachedCredentialType.OAUTH_REFRESH_TOKEN.getValue(), encoder.encodeToString(SOME_REFRESH_TOKEN.getBytes(StandardCharsets.UTF_8)));
        SFLoginInput loginInputExternalOAuth = this.createLoginInputWithExternalOAuth();
        CredentialManager.writeOAuthAccessToken((SFLoginInput)loginInputExternalOAuth);
        ((SecureStorageManager)Mockito.verify((Object)mockSecureStorageManager, (VerificationMode)Mockito.times((int)1))).setCredential(EXTERNAL_OAUTH_HOST, SOME_USER, CachedCredentialType.OAUTH_ACCESS_TOKEN.getValue(), encoder.encodeToString(SOME_ACCESS_TOKEN.getBytes(StandardCharsets.UTF_8)));
        CredentialManager.writeOAuthRefreshToken((SFLoginInput)loginInputExternalOAuth);
        ((SecureStorageManager)Mockito.verify((Object)mockSecureStorageManager, (VerificationMode)Mockito.times((int)1))).setCredential(EXTERNAL_OAUTH_HOST, SOME_USER, CachedCredentialType.OAUTH_REFRESH_TOKEN.getValue(), encoder.encodeToString(SOME_REFRESH_TOKEN.getBytes(StandardCharsets.UTF_8)));
        SFLoginInput loginInputDPoP = this.createLoginInputWithDPoPPublicKey();
        String dpopBundledToken = encoder.encodeToString(SOME_ACCESS_TOKEN.getBytes(StandardCharsets.UTF_8)) + "." + encoder.encodeToString(SOME_DPOP_PUBLIC_KEY.getBytes(StandardCharsets.UTF_8));
        CredentialManager.writeDPoPBundledAccessToken((SFLoginInput)loginInputDPoP);
        ((SecureStorageManager)Mockito.verify((Object)mockSecureStorageManager, (VerificationMode)Mockito.times((int)1))).setCredential(SNOWFLAKE_HOST, SOME_USER, CachedCredentialType.DPOP_BUNDLED_ACCESS_TOKEN.getValue(), dpopBundledToken);
    }

    @Test
    public void shouldProperlyDeleteTokensFromCache() throws SFException {
        SFLoginInput loginInputSnowflakeOAuth = this.createLoginInputWithSnowflakeServer();
        CredentialManager.deleteIdTokenCacheEntry((String)loginInputSnowflakeOAuth.getHostFromServerUrl(), (String)loginInputSnowflakeOAuth.getUserName());
        ((SecureStorageManager)Mockito.verify((Object)mockSecureStorageManager, (VerificationMode)Mockito.times((int)1))).deleteCredential(SNOWFLAKE_HOST, SOME_USER, CachedCredentialType.ID_TOKEN.getValue());
        CredentialManager.deleteMfaTokenCacheEntry((String)loginInputSnowflakeOAuth.getHostFromServerUrl(), (String)loginInputSnowflakeOAuth.getUserName());
        ((SecureStorageManager)Mockito.verify((Object)mockSecureStorageManager, (VerificationMode)Mockito.times((int)1))).deleteCredential(SNOWFLAKE_HOST, SOME_USER, CachedCredentialType.MFA_TOKEN.getValue());
        CredentialManager.deleteOAuthAccessTokenCacheEntry((SFLoginInput)loginInputSnowflakeOAuth);
        ((SecureStorageManager)Mockito.verify((Object)mockSecureStorageManager, (VerificationMode)Mockito.times((int)1))).deleteCredential(SNOWFLAKE_HOST, SOME_USER, CachedCredentialType.OAUTH_ACCESS_TOKEN.getValue());
        CredentialManager.deleteOAuthRefreshTokenCacheEntry((SFLoginInput)loginInputSnowflakeOAuth);
        ((SecureStorageManager)Mockito.verify((Object)mockSecureStorageManager, (VerificationMode)Mockito.times((int)1))).deleteCredential(SNOWFLAKE_HOST, SOME_USER, CachedCredentialType.OAUTH_REFRESH_TOKEN.getValue());
        SFLoginInput loginInputExternalOAuth = this.createLoginInputWithExternalOAuth();
        CredentialManager.deleteOAuthAccessTokenCacheEntry((SFLoginInput)loginInputExternalOAuth);
        ((SecureStorageManager)Mockito.verify((Object)mockSecureStorageManager, (VerificationMode)Mockito.times((int)1))).deleteCredential(EXTERNAL_OAUTH_HOST, SOME_USER, CachedCredentialType.OAUTH_ACCESS_TOKEN.getValue());
        CredentialManager.deleteOAuthRefreshTokenCacheEntry((SFLoginInput)loginInputExternalOAuth);
        ((SecureStorageManager)Mockito.verify((Object)mockSecureStorageManager, (VerificationMode)Mockito.times((int)1))).deleteCredential(EXTERNAL_OAUTH_HOST, SOME_USER, CachedCredentialType.OAUTH_REFRESH_TOKEN.getValue());
        SFLoginInput loginInputDPoP = this.createLoginInputWithDPoPPublicKey();
        CredentialManager.deleteDPoPBundledAccessTokenCacheEntry((SFLoginInput)loginInputDPoP);
        ((SecureStorageManager)Mockito.verify((Object)mockSecureStorageManager, (VerificationMode)Mockito.times((int)1))).deleteCredential(SNOWFLAKE_HOST, SOME_USER, CachedCredentialType.DPOP_BUNDLED_ACCESS_TOKEN.getValue());
    }

    @Test
    public void shouldProperlyUpdateInputWithTokensFromCache() throws SFException {
        Base64.Encoder encoder = Base64.getEncoder();
        SFLoginInput loginInputSnowflakeOAuth = this.createLoginInputWithSnowflakeServer();
        Mockito.when((Object)mockSecureStorageManager.getCredential(SNOWFLAKE_HOST, SOME_USER, CachedCredentialType.ID_TOKEN.getValue())).thenReturn((Object)encoder.encodeToString(SOME_ID_TOKEN_FROM_CACHE.getBytes(StandardCharsets.UTF_8)));
        CredentialManager.fillCachedIdToken((SFLoginInput)loginInputSnowflakeOAuth);
        Mockito.when((Object)mockSecureStorageManager.getCredential(SNOWFLAKE_HOST, SOME_USER, CachedCredentialType.MFA_TOKEN.getValue())).thenReturn((Object)encoder.encodeToString(SOME_MFA_TOKEN_FROM_CACHE.getBytes(StandardCharsets.UTF_8)));
        CredentialManager.fillCachedMfaToken((SFLoginInput)loginInputSnowflakeOAuth);
        Assertions.assertEquals((Object)SOME_ID_TOKEN_FROM_CACHE, (Object)loginInputSnowflakeOAuth.getIdToken());
        Assertions.assertEquals((Object)SOME_MFA_TOKEN_FROM_CACHE, (Object)loginInputSnowflakeOAuth.getMfaToken());
        Mockito.when((Object)mockSecureStorageManager.getCredential(SNOWFLAKE_HOST, SOME_USER, CachedCredentialType.OAUTH_ACCESS_TOKEN.getValue())).thenReturn((Object)encoder.encodeToString(ACCESS_TOKEN_FROM_CACHE.getBytes(StandardCharsets.UTF_8)));
        CredentialManager.fillCachedOAuthAccessToken((SFLoginInput)loginInputSnowflakeOAuth);
        Mockito.when((Object)mockSecureStorageManager.getCredential(SNOWFLAKE_HOST, SOME_USER, CachedCredentialType.OAUTH_REFRESH_TOKEN.getValue())).thenReturn((Object)encoder.encodeToString(REFRESH_TOKEN_FROM_CACHE.getBytes(StandardCharsets.UTF_8)));
        CredentialManager.fillCachedOAuthRefreshToken((SFLoginInput)loginInputSnowflakeOAuth);
        Assertions.assertEquals((Object)ACCESS_TOKEN_FROM_CACHE, (Object)loginInputSnowflakeOAuth.getOauthAccessToken());
        Assertions.assertEquals((Object)REFRESH_TOKEN_FROM_CACHE, (Object)loginInputSnowflakeOAuth.getOauthRefreshToken());
        SFLoginInput loginInputExternalOAuth = this.createLoginInputWithExternalOAuth();
        Mockito.when((Object)mockSecureStorageManager.getCredential(EXTERNAL_OAUTH_HOST, SOME_USER, CachedCredentialType.OAUTH_ACCESS_TOKEN.getValue())).thenReturn((Object)encoder.encodeToString(EXTERNAL_ACCESS_TOKEN_FROM_CACHE.getBytes(StandardCharsets.UTF_8)));
        CredentialManager.fillCachedOAuthAccessToken((SFLoginInput)loginInputExternalOAuth);
        Mockito.when((Object)mockSecureStorageManager.getCredential(EXTERNAL_OAUTH_HOST, SOME_USER, CachedCredentialType.OAUTH_REFRESH_TOKEN.getValue())).thenReturn((Object)encoder.encodeToString(EXTERNAL_REFRESH_TOKEN_FROM_CACHE.getBytes(StandardCharsets.UTF_8)));
        CredentialManager.fillCachedOAuthRefreshToken((SFLoginInput)loginInputExternalOAuth);
        Assertions.assertEquals((Object)EXTERNAL_ACCESS_TOKEN_FROM_CACHE, (Object)loginInputExternalOAuth.getOauthAccessToken());
        Assertions.assertEquals((Object)EXTERNAL_REFRESH_TOKEN_FROM_CACHE, (Object)loginInputExternalOAuth.getOauthRefreshToken());
        SFLoginInput loginInputDPoP = this.createLoginInputWithDPoPPublicKey();
        String dpopBundledToken = encoder.encodeToString(SOME_ACCESS_TOKEN.getBytes(StandardCharsets.UTF_8)) + "." + encoder.encodeToString(SOME_DPOP_PUBLIC_KEY.getBytes(StandardCharsets.UTF_8));
        Mockito.when((Object)mockSecureStorageManager.getCredential(SNOWFLAKE_HOST, SOME_USER, CachedCredentialType.DPOP_BUNDLED_ACCESS_TOKEN.getValue())).thenReturn((Object)dpopBundledToken);
        CredentialManager.fillCachedDPoPBundledAccessToken((SFLoginInput)loginInputDPoP);
        Assertions.assertEquals((Object)SOME_ACCESS_TOKEN, (Object)loginInputDPoP.getOauthAccessToken());
        Assertions.assertEquals((Object)SOME_DPOP_PUBLIC_KEY, (Object)loginInputDPoP.getDPoPPublicKey());
    }

    private SFLoginInput createLoginInputWithExternalOAuth() {
        SFLoginInput loginInput = this.createGenericLoginInput();
        loginInput.setOauthLoginInput(new SFOauthLoginInput(null, null, null, null, "https://some-external-oauth-host.com/oauth/token", null));
        return loginInput;
    }

    private SFLoginInput createLoginInputWithSnowflakeServer() {
        SFLoginInput loginInput = this.createGenericLoginInput();
        loginInput.setOauthLoginInput(new SFOauthLoginInput(null, null, null, null, null, null));
        loginInput.setServerUrl("https://some-account.us-west-2.aws.snowflakecomputing.com:443/");
        return loginInput;
    }

    private SFLoginInput createLoginInputWithDPoPPublicKey() {
        SFLoginInput loginInput = this.createLoginInputWithSnowflakeServer();
        loginInput.setDPoPPublicKey(SOME_DPOP_PUBLIC_KEY);
        return loginInput;
    }

    private SFLoginInput createGenericLoginInput() {
        SFLoginInput loginInput = new SFLoginInput();
        loginInput.setOauthAccessToken(SOME_ACCESS_TOKEN);
        loginInput.setOauthRefreshToken(SOME_REFRESH_TOKEN);
        loginInput.setUserName(SOME_USER);
        return loginInput;
    }
}

