/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import net.snowflake.client.core.MockAuthExternalBrowserHandlers;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SessionUtilExternalBrowser;
import org.mockito.Mockito;

class FakeSessionUtilExternalBrowser
extends SessionUtilExternalBrowser {
    static final String MOCK_SAML_TOKEN = "MOCK_SAML_TOKEN";
    private final ServerSocket mockServerSocket;

    public static SessionUtilExternalBrowser createInstance(SFLoginInput loginInput, boolean isPost) {
        return new FakeSessionUtilExternalBrowser(loginInput, isPost);
    }

    private FakeSessionUtilExternalBrowser(SFLoginInput loginInput, boolean isPost) {
        super(loginInput, (SessionUtilExternalBrowser.AuthExternalBrowserHandlers)new MockAuthExternalBrowserHandlers());
        try {
            this.mockServerSocket = FakeSessionUtilExternalBrowser.initMockServerSocket(isPost);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to initialize ServerSocket mock");
        }
    }

    private static ServerSocket initMockServerSocket(boolean isPost) throws IOException {
        Socket mockSocket = (Socket)Mockito.mock(Socket.class);
        String str = isPost ? String.format("POST / HTTP/1.1\r\nUSER-AGENT: snowflake client\r\n\r\ntoken=%s&confirm=1", MOCK_SAML_TOKEN) : String.format("GET /?token=%s&confirm=1 HTTP/1.1\r\nUSER-AGENT: snowflake client", MOCK_SAML_TOKEN);
        ByteArrayInputStream stream = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));
        Mockito.when((Object)mockSocket.getInputStream()).thenReturn((Object)stream);
        Mockito.when((Object)mockSocket.getOutputStream()).thenReturn((Object)new NullOutputStream());
        ServerSocket mockServerSocket = (ServerSocket)Mockito.mock(ServerSocket.class);
        Mockito.when((Object)mockServerSocket.getLocalPort()).thenReturn((Object)12345);
        Mockito.when((Object)mockServerSocket.accept()).thenReturn((Object)mockSocket);
        return mockServerSocket;
    }

    protected ServerSocket getServerSocket() throws SFException {
        return this.mockServerSocket;
    }

    protected int getLocalPort(ServerSocket ssocket) {
        return super.getLocalPort(ssocket);
    }

    static class NullOutputStream
    extends OutputStream {
        NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

