/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.File;
import net.snowflake.client.annotations.RunOnLinuxOrMac;
import net.snowflake.client.core.Constants;
import net.snowflake.client.core.FileCacheManager;
import net.snowflake.client.core.FileUtil;
import net.snowflake.client.jdbc.SnowflakeUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class FileCacheManagerDefaultDirTest {
    @Test
    @RunOnLinuxOrMac
    public void shouldCreateCacheDirForLinuxXDG() {
        try (MockedStatic constantsMockedStatic = Mockito.mockStatic(Constants.class);){
            constantsMockedStatic.when(Constants::getOS).thenReturn((Object)Constants.OS.LINUX);
            try (MockedStatic snowflakeUtilMockedStatic = Mockito.mockStatic(SnowflakeUtil.class);){
                snowflakeUtilMockedStatic.when(() -> SnowflakeUtil.systemGetEnv((String)"XDG_CACHE_HOME")).thenReturn((Object)"/XDG/Cache/");
                try (MockedStatic fileUtilMockedStatic = Mockito.mockStatic(FileUtil.class);){
                    fileUtilMockedStatic.when(() -> FileUtil.isWritable((String)"/XDG/Cache/")).thenReturn((Object)true);
                    File defaultCacheDir = FileCacheManager.getDefaultCacheDir();
                    Assertions.assertNotNull((Object)defaultCacheDir);
                    Assertions.assertEquals((Object)"/XDG/Cache/snowflake", (Object)defaultCacheDir.getAbsolutePath());
                }
            }
        }
    }

    @Test
    @RunOnLinuxOrMac
    public void shouldCreateCacheDirForLinuxWithoutXDG() {
        try (MockedStatic constantsMockedStatic = Mockito.mockStatic(Constants.class);){
            constantsMockedStatic.when(Constants::getOS).thenReturn((Object)Constants.OS.LINUX);
            try (MockedStatic snowflakeUtilMockedStatic = Mockito.mockStatic(SnowflakeUtil.class);){
                snowflakeUtilMockedStatic.when(() -> SnowflakeUtil.systemGetEnv((String)"XDG_CACHE_HOME")).thenReturn(null);
                snowflakeUtilMockedStatic.when(() -> SnowflakeUtil.systemGetProperty((String)"user.home")).thenReturn((Object)"/User/Home");
                try (MockedStatic fileUtilMockedStatic = Mockito.mockStatic(FileUtil.class);){
                    fileUtilMockedStatic.when(() -> FileUtil.isWritable((String)"/User/Home")).thenReturn((Object)true);
                    File defaultCacheDir = FileCacheManager.getDefaultCacheDir();
                    Assertions.assertNotNull((Object)defaultCacheDir);
                    Assertions.assertEquals((Object)"/User/Home/.cache/snowflake", (Object)defaultCacheDir.getAbsolutePath());
                }
            }
        }
    }

    @Test
    @RunOnLinuxOrMac
    public void shouldCreateCacheDirForWindows() {
        try (MockedStatic constantsMockedStatic = Mockito.mockStatic(Constants.class);){
            constantsMockedStatic.when(Constants::getOS).thenReturn((Object)Constants.OS.WINDOWS);
            try (MockedStatic snowflakeUtilMockedStatic = Mockito.mockStatic(SnowflakeUtil.class);){
                snowflakeUtilMockedStatic.when(() -> SnowflakeUtil.systemGetProperty((String)"user.home")).thenReturn((Object)"/User/Home");
                try (MockedStatic fileUtilMockedStatic = Mockito.mockStatic(FileUtil.class);){
                    fileUtilMockedStatic.when(() -> FileUtil.isWritable((String)"/User/Home")).thenReturn((Object)true);
                    File defaultCacheDir = FileCacheManager.getDefaultCacheDir();
                    Assertions.assertNotNull((Object)defaultCacheDir);
                    Assertions.assertEquals((Object)"/User/Home/AppData/Local/Snowflake/Caches", (Object)defaultCacheDir.getAbsolutePath());
                }
            }
        }
    }

    @Test
    @RunOnLinuxOrMac
    public void shouldCreateCacheDirForMacOS() {
        try (MockedStatic constantsMockedStatic = Mockito.mockStatic(Constants.class);){
            constantsMockedStatic.when(Constants::getOS).thenReturn((Object)Constants.OS.MAC);
            try (MockedStatic snowflakeUtilMockedStatic = Mockito.mockStatic(SnowflakeUtil.class);){
                snowflakeUtilMockedStatic.when(() -> SnowflakeUtil.systemGetProperty((String)"user.home")).thenReturn((Object)"/User/Home");
                try (MockedStatic fileUtilMockedStatic = Mockito.mockStatic(FileUtil.class);){
                    fileUtilMockedStatic.when(() -> FileUtil.isWritable((String)"/User/Home")).thenReturn((Object)true);
                    File defaultCacheDir = FileCacheManager.getDefaultCacheDir();
                    Assertions.assertNotNull((Object)defaultCacheDir);
                    Assertions.assertEquals((Object)"/User/Home/Library/Caches/Snowflake", (Object)defaultCacheDir.getAbsolutePath());
                }
            }
        }
    }

    @Test
    @RunOnLinuxOrMac
    public void shouldReturnNullWhenNoHomeDirSet() {
        try (MockedStatic constantsMockedStatic = Mockito.mockStatic(Constants.class);){
            constantsMockedStatic.when(Constants::getOS).thenReturn((Object)Constants.OS.LINUX);
            try (MockedStatic snowflakeUtilMockedStatic = Mockito.mockStatic(SnowflakeUtil.class);){
                snowflakeUtilMockedStatic.when(() -> SnowflakeUtil.systemGetEnv((String)"XDG_CACHE_HOME")).thenReturn(null);
                snowflakeUtilMockedStatic.when(() -> SnowflakeUtil.systemGetProperty((String)"user.home")).thenReturn(null);
                File defaultCacheDir = FileCacheManager.getDefaultCacheDir();
                Assertions.assertNull((Object)defaultCacheDir);
            }
        }
    }
}

