/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.SnowflakeMutableProxyRoutePlanner;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.Configurable;
import org.apache.http.impl.client.CloseableHttpClient;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HttpUtilTest {
    @Test
    public void buildHttpClientRace() throws InterruptedException {
        HttpUtil.httpClient.clear();
        CountDownLatch latch = new CountDownLatch(1);
        ConcurrentLinkedQueue failures = new ConcurrentLinkedQueue();
        HttpClientSettingsKey noProxyKey = new HttpClientSettingsKey(null);
        HttpClientSettingsKey proxyKey = new HttpClientSettingsKey(null, "some.proxy.host", 8080, null, null, null, "http", null, Boolean.valueOf(false));
        Thread noProxyThread = new Thread(() -> HttpUtilTest.verifyProxyUsage(noProxyKey, failures, latch), "noProxyThread");
        noProxyThread.start();
        Thread withProxyThread = new Thread(() -> HttpUtilTest.verifyProxyUsage(proxyKey, failures, latch), "withProxyThread");
        withProxyThread.start();
        boolean failed = latch.await(1L, TimeUnit.SECONDS);
        noProxyThread.interrupt();
        withProxyThread.interrupt();
        if (failed) {
            AbstractMap.SimpleEntry failure = (AbstractMap.SimpleEntry)failures.remove();
            Assertions.fail((String)(((Thread)failure.getKey()).getName() + " failed"), (Throwable)((Throwable)failure.getValue()));
        }
    }

    private static void verifyProxyUsage(HttpClientSettingsKey key, Queue<AbstractMap.SimpleEntry<Thread, Throwable>> failures, CountDownLatch latch) {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                CloseableHttpClient client = HttpUtil.buildHttpClient((HttpClientSettingsKey)key, null, (boolean)false);
                try {
                    HttpUtilTest.assertHttpClientUsesProxy(client, key.usesProxy());
                }
                finally {
                    if (client == null) continue;
                    client.close();
                }
            }
            catch (Throwable e) {
                failures.add(new AbstractMap.SimpleEntry<Thread, Throwable>(Thread.currentThread(), e));
                latch.countDown();
                break;
            }
        }
    }

    private static void assertHttpClientUsesProxy(CloseableHttpClient client, boolean proxyUsed) {
        HttpUtilTest.assertRequestConfigWithoutProxyConfig(client);
        HttpUtilTest.assertRoutePlannerOverridden(client, proxyUsed);
    }

    private static void assertRequestConfigWithoutProxyConfig(CloseableHttpClient client) {
        MatcherAssert.assertThat((Object)client, (Matcher)CoreMatchers.instanceOf(Configurable.class));
        Configurable c = (Configurable)client;
        RequestConfig config = c.getConfig();
        Assertions.assertNull((Object)config.getProxy(), (String)"request config has configured proxy");
    }

    private static void assertRoutePlannerOverridden(CloseableHttpClient client, boolean proxyUsed) {
        try {
            Field routePlannerField = client.getClass().getDeclaredField("routePlanner");
            routePlannerField.setAccessible(true);
            Matcher snowflakeProxyPlannerClassMatcher = CoreMatchers.instanceOf(SnowflakeMutableProxyRoutePlanner.class);
            MatcherAssert.assertThat((Object)routePlannerField.get(client), (Matcher)(proxyUsed ? snowflakeProxyPlannerClassMatcher : CoreMatchers.not((Matcher)snowflakeProxyPlannerClassMatcher)));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

