/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.zip.GZIPInputStream;
import net.snowflake.client.core.EventUtil;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.jdbc.BaseJDBCTest;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

@Tag(value="core")
public class IncidentUtilLatestIT
extends BaseJDBCTest {
    @TempDir
    private File tmpFolder;
    private static final String FILE_NAME = "sf_incident_123456.dmp.gz";

    @Test
    public void testOneLinerDescription() {
        String desc = IncidentUtil.oneLiner((String)"unexpected exception", (Throwable)new IOException("File not found"));
        Assertions.assertEquals((Object)"unexpected exception java.io.IOException: File not found", (Object)desc.substring(0, 56));
    }

    @Test
    public void testDumpVmMetrics() throws IOException {
        File dumpDir = new File(this.tmpFolder, "dump");
        dumpDir.mkdirs();
        String dumpPath = dumpDir.getCanonicalPath();
        System.setProperty("snowflake.dump_path", dumpPath);
        String incidentId = "123456";
        IncidentUtil.dumpVmMetrics((String)incidentId);
        String targetVMFileLocation = EventUtil.getDumpPathPrefix() + "/" + "sf_incident_" + incidentId + ".dmp.gz";
        try (FileInputStream fis = new FileInputStream(targetVMFileLocation);
             GZIPInputStream gzip = new GZIPInputStream(fis);){
            StringWriter sWriter = new StringWriter();
            IOUtils.copy((InputStream)gzip, (Writer)sWriter, (String)"UTF-8");
            String output = sWriter.toString();
            Assertions.assertEquals((Object)"\n\n\n---------------------------  METRICS ---------------------------\n\n", (Object)output.substring(0, 69));
            sWriter.close();
        }
    }
}

