/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.amazonaws.util.StringUtils;
import java.net.URI;
import java.time.Duration;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SFOauthLoginInput;
import net.snowflake.client.core.SessionUtilExternalBrowser;
import net.snowflake.client.core.auth.oauth.AccessTokenProvider;
import net.snowflake.client.core.auth.oauth.OAuthAuthorizationCodeAccessTokenProvider;
import net.snowflake.client.core.auth.oauth.StateProvider;
import net.snowflake.client.core.auth.oauth.TokenResponseDTO;
import net.snowflake.client.jdbc.BaseWiremockTest;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="core")
public class OAuthAuthorizationCodeFlowLatestIT
extends BaseWiremockTest {
    private static final String SCENARIOS_BASE_DIR = "/wiremock/mappings/oauth/authorization_code";
    private static final String SUCCESSFUL_FLOW_SCENARIO_MAPPINGS = "/wiremock/mappings/oauth/authorization_code/successful_flow.json";
    private static final String SUCCESSFUL_DPOP_FLOW_SCENARIO_MAPPINGS = "/wiremock/mappings/oauth/authorization_code/successful_dpop_flow.json";
    private static final String DPOP_NONCE_ERROR_SCENARIO_MAPPINGS = "/wiremock/mappings/oauth/authorization_code/dpop_nonce_error_flow.json";
    private static final String BROWSER_TIMEOUT_SCENARIO_MAPPING = "/wiremock/mappings/oauth/authorization_code/browser_timeout_authorization_error.json";
    private static final String INVALID_SCOPE_SCENARIO_MAPPING = "/wiremock/mappings/oauth/authorization_code/invalid_scope_error.json";
    private static final String INVALID_STATE_SCENARIO_MAPPING = "/wiremock/mappings/oauth/authorization_code/invalid_state_error.json";
    private static final String TOKEN_REQUEST_ERROR_SCENARIO_MAPPING = "/wiremock/mappings/oauth/authorization_code/token_request_error.json";
    private static final String CUSTOM_URLS_SCENARIO_MAPPINGS = "/wiremock/mappings/oauth/authorization_code/external_idp_custom_urls.json";
    private static final SFLogger logger = SFLoggerFactory.getLogger(OAuthAuthorizationCodeFlowLatestIT.class);
    private final SessionUtilExternalBrowser.AuthExternalBrowserHandlers wiremockProxyRequestBrowserHandler = new WiremockProxyRequestBrowserHandler();
    private final AccessTokenProvider provider = new OAuthAuthorizationCodeAccessTokenProvider(this.wiremockProxyRequestBrowserHandler, (StateProvider)new MockStateProvider(), 30L);

    @Test
    public void successfulFlowScenario() throws SFException {
        this.importMappingFromResources(SUCCESSFUL_FLOW_SCENARIO_MAPPINGS);
        SFLoginInput loginInput = this.createLoginInputStub("http://localhost:8009/snowflake/oauth-redirect", null, null);
        TokenResponseDTO tokenResponse = this.provider.getAccessToken(loginInput);
        String accessToken = tokenResponse.getAccessToken();
        Assertions.assertFalse((boolean)StringUtils.isNullOrEmpty((String)accessToken));
        Assertions.assertEquals((Object)"access-token-123", (Object)accessToken);
    }

    @Test
    public void successfulFlowDPoPScenario() throws SFException {
        this.importMappingFromResources(SUCCESSFUL_DPOP_FLOW_SCENARIO_MAPPINGS);
        SFLoginInput loginInput = this.createLoginInputStubWithDPoPEnabled("http://localhost:8012/snowflake/oauth-redirect", null, null);
        TokenResponseDTO tokenResponse = this.provider.getAccessToken(loginInput);
        String accessToken = tokenResponse.getAccessToken();
        Assertions.assertFalse((boolean)StringUtils.isNullOrEmpty((String)accessToken));
        Assertions.assertEquals((Object)"access-token-123", (Object)accessToken);
    }

    @Test
    public void successfulFlowDPoPScenarioWithNonce() throws SFException {
        this.importMappingFromResources(DPOP_NONCE_ERROR_SCENARIO_MAPPINGS);
        SFLoginInput loginInput = this.createLoginInputStubWithDPoPEnabled("http://localhost:8013/snowflake/oauth-redirect", null, null);
        TokenResponseDTO tokenResponse = this.provider.getAccessToken(loginInput);
        String accessToken = tokenResponse.getAccessToken();
        Assertions.assertFalse((boolean)StringUtils.isNullOrEmpty((String)accessToken));
        Assertions.assertEquals((Object)"access-token-123", (Object)accessToken);
    }

    @Test
    public void customUrlsScenario() throws SFException {
        this.importMappingFromResources(CUSTOM_URLS_SCENARIO_MAPPINGS);
        SFLoginInput loginInput = this.createLoginInputStub("http://localhost:8007/snowflake/oauth-redirect", String.format("http://%s:%d/authorization", "localhost", wiremockHttpPort), String.format("http://%s:%d/tokenrequest", "localhost", wiremockHttpPort));
        TokenResponseDTO tokenResponse = this.provider.getAccessToken(loginInput);
        String accessToken = tokenResponse.getAccessToken();
        Assertions.assertFalse((boolean)StringUtils.isNullOrEmpty((String)accessToken));
        Assertions.assertEquals((Object)"access-token-123", (Object)accessToken);
    }

    @Test
    public void browserTimeoutFlowScenario() throws SFException {
        this.importMappingFromResources(BROWSER_TIMEOUT_SCENARIO_MAPPING);
        SFLoginInput loginInput = this.createLoginInputStub("http://localhost:8004/snowflake/oauth-redirect", null, null);
        OAuthAuthorizationCodeAccessTokenProvider provider = new OAuthAuthorizationCodeAccessTokenProvider(this.wiremockProxyRequestBrowserHandler, (StateProvider)new MockStateProvider(), 1L);
        SFException e = (SFException)Assertions.assertThrows(SFException.class, () -> OAuthAuthorizationCodeFlowLatestIT.lambda$browserTimeoutFlowScenario$0((AccessTokenProvider)provider, loginInput));
        Assertions.assertTrue((boolean)e.getMessage().contains("Authorization request timed out. Snowflake driver did not receive authorization code back to the redirect URI. Verify your security integration and driver configuration."));
    }

    @Test
    public void invalidScopeFlowScenario() {
        this.importMappingFromResources(INVALID_SCOPE_SCENARIO_MAPPING);
        SFLoginInput loginInput = this.createLoginInputStub("http://localhost:8002/snowflake/oauth-redirect", null, null);
        SFException e = (SFException)Assertions.assertThrows(SFException.class, () -> this.provider.getAccessToken(loginInput));
        Assertions.assertTrue((boolean)e.getMessage().contains("Error during authorization: invalid_scope, One or more scopes are not configured for the authorization server resource."));
    }

    @Test
    public void invalidStateFlowScenario() {
        this.importMappingFromResources(INVALID_STATE_SCENARIO_MAPPING);
        SFLoginInput loginInput = this.createLoginInputStub("http://localhost:8010/snowflake/oauth-redirect", null, null);
        SFException e = (SFException)Assertions.assertThrows(SFException.class, () -> this.provider.getAccessToken(loginInput));
        Assertions.assertTrue((boolean)e.getMessage().contains("Error during OAuth Authorization Code authentication: Invalid authorization request redirection state: invalidstate, expected: abc123"));
    }

    @Test
    public void tokenRequestErrorFlowScenario() {
        this.importMappingFromResources(TOKEN_REQUEST_ERROR_SCENARIO_MAPPING);
        SFLoginInput loginInput = this.createLoginInputStub("http://localhost:8003/snowflake/oauth-redirect", null, null);
        SFException e = (SFException)Assertions.assertThrows(SFException.class, () -> this.provider.getAccessToken(loginInput));
        Assertions.assertTrue((boolean)e.getMessage().contains("JDBC driver encountered communication error. Message: HTTP status=400"));
    }

    private SFLoginInput createLoginInputStub(String redirectUri, String authorizationUrl, String tokenRequestUrl) {
        SFLoginInput loginInputStub = new SFLoginInput();
        loginInputStub.setServerUrl(String.format("http://%s:%d/", "localhost", wiremockHttpPort));
        loginInputStub.setOauthLoginInput(new SFOauthLoginInput("123", "123", redirectUri, authorizationUrl, tokenRequestUrl, "session:role:ANALYST"));
        loginInputStub.setSocketTimeout(Duration.ofMinutes(5L));
        loginInputStub.setHttpClientSettingsKey(new HttpClientSettingsKey(OCSPMode.FAIL_OPEN));
        return loginInputStub;
    }

    private SFLoginInput createLoginInputStubWithDPoPEnabled(String redirectUri, String authorizationUrl, String tokenRequestUrl) {
        SFLoginInput loginInputStub = this.createLoginInputStub(redirectUri, authorizationUrl, tokenRequestUrl);
        loginInputStub.setDPoPEnabled(true);
        return loginInputStub;
    }

    private static /* synthetic */ void lambda$browserTimeoutFlowScenario$0(AccessTokenProvider provider, SFLoginInput loginInput) throws Throwable {
        provider.getAccessToken(loginInput);
    }

    static class MockStateProvider
    implements StateProvider<String> {
        MockStateProvider() {
        }

        public String getState() {
            return "abc123";
        }
    }

    static class WiremockProxyRequestBrowserHandler
    implements SessionUtilExternalBrowser.AuthExternalBrowserHandlers {
        WiremockProxyRequestBrowserHandler() {
        }

        public HttpPost build(URI uri) {
            return null;
        }

        public void openBrowser(String ssoUrl) {
            try (CloseableHttpClient client = HttpClients.createDefault();){
                logger.debug("executing browser request to redirect uri: {}", new Object[]{ssoUrl});
                CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpGet(ssoUrl));
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new RuntimeException("Invalid response from " + ssoUrl);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void output(String msg) {
        }
    }
}

