/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.amazonaws.util.StringUtils;
import java.time.Duration;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SFOauthLoginInput;
import net.snowflake.client.core.auth.oauth.AccessTokenProvider;
import net.snowflake.client.core.auth.oauth.OAuthClientCredentialsAccessTokenProvider;
import net.snowflake.client.core.auth.oauth.TokenResponseDTO;
import net.snowflake.client.jdbc.BaseWiremockTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="core")
public class OAuthClientCredentialsFlowLatestIT
extends BaseWiremockTest {
    private static final String SCENARIOS_BASE_DIR = "/wiremock/mappings/oauth/client_credentials";
    private static final String SUCCESSFUL_FLOW_SCENARIO_MAPPINGS = "/wiremock/mappings/oauth/client_credentials/successful_flow.json";
    private static final String SUCCESSFUL_DPOP_FLOW_SCENARIO_MAPPINGS = "/wiremock/mappings/oauth/client_credentials/successful_dpop_flow.json";
    private static final String DPOP_NONCE_ERROR_SCENARIO_MAPPINGS = "/wiremock/mappings/oauth/client_credentials/dpop_nonce_error_flow.json";
    private static final String TOKEN_REQUEST_ERROR_SCENARIO_MAPPING = "/wiremock/mappings/oauth/client_credentials/token_request_error.json";

    @Test
    public void successfulFlowScenario() throws SFException {
        this.importMappingFromResources(SUCCESSFUL_FLOW_SCENARIO_MAPPINGS);
        SFLoginInput loginInput = this.createLoginInputStub();
        OAuthClientCredentialsAccessTokenProvider provider = new OAuthClientCredentialsAccessTokenProvider();
        TokenResponseDTO tokenResponse = provider.getAccessToken(loginInput);
        String accessToken = tokenResponse.getAccessToken();
        Assertions.assertFalse((boolean)StringUtils.isNullOrEmpty((String)accessToken));
        Assertions.assertEquals((Object)"access-token-123", (Object)accessToken);
    }

    @Test
    public void successfulFlowScenarioDPoP() throws SFException {
        this.importMappingFromResources(SUCCESSFUL_DPOP_FLOW_SCENARIO_MAPPINGS);
        SFLoginInput loginInput = this.createLoginInputStubWithDPoPEnabled();
        OAuthClientCredentialsAccessTokenProvider provider = new OAuthClientCredentialsAccessTokenProvider();
        TokenResponseDTO tokenResponse = provider.getAccessToken(loginInput);
        String accessToken = tokenResponse.getAccessToken();
        Assertions.assertFalse((boolean)StringUtils.isNullOrEmpty((String)accessToken));
        Assertions.assertEquals((Object)"access-token-123", (Object)accessToken);
    }

    @Test
    public void successfulFlowScenarioDPoPNonceError() throws SFException {
        this.importMappingFromResources(DPOP_NONCE_ERROR_SCENARIO_MAPPINGS);
        SFLoginInput loginInput = this.createLoginInputStubWithDPoPEnabled();
        OAuthClientCredentialsAccessTokenProvider provider = new OAuthClientCredentialsAccessTokenProvider();
        TokenResponseDTO tokenResponse = provider.getAccessToken(loginInput);
        String accessToken = tokenResponse.getAccessToken();
        Assertions.assertFalse((boolean)StringUtils.isNullOrEmpty((String)accessToken));
        Assertions.assertEquals((Object)"access-token-123", (Object)accessToken);
    }

    @Test
    public void tokenRequestErrorFlowScenario() throws SFException {
        this.importMappingFromResources(TOKEN_REQUEST_ERROR_SCENARIO_MAPPING);
        SFLoginInput loginInput = this.createLoginInputStub();
        OAuthClientCredentialsAccessTokenProvider provider = new OAuthClientCredentialsAccessTokenProvider();
        SFException e = (SFException)Assertions.assertThrows(SFException.class, () -> OAuthClientCredentialsFlowLatestIT.lambda$tokenRequestErrorFlowScenario$0((AccessTokenProvider)provider, loginInput));
        Assertions.assertTrue((boolean)e.getMessage().contains("JDBC driver encountered communication error. Message: HTTP status=400"));
    }

    private SFLoginInput createLoginInputStub() {
        SFLoginInput loginInputStub = new SFLoginInput();
        loginInputStub.setServerUrl(String.format("http://%s:%d/", "localhost", wiremockHttpPort));
        loginInputStub.setOauthLoginInput(new SFOauthLoginInput("123", "123", null, null, String.format("http://%s:%d/oauth/token-request", "localhost", wiremockHttpPort), "session:role:ANALYST"));
        loginInputStub.setSocketTimeout(Duration.ofMinutes(5L));
        loginInputStub.setHttpClientSettingsKey(new HttpClientSettingsKey(OCSPMode.FAIL_OPEN));
        return loginInputStub;
    }

    private SFLoginInput createLoginInputStubWithDPoPEnabled() {
        SFLoginInput loginInputStub = this.createLoginInputStub();
        loginInputStub.setDPoPEnabled(true);
        return loginInputStub;
    }

    private static /* synthetic */ void lambda$tokenRequestErrorFlowScenario$0(AccessTokenProvider provider, SFLoginInput loginInput) throws Throwable {
        provider.getAccessToken(loginInput);
    }
}

