/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import net.snowflake.client.core.CredentialManager;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SFLoginOutput;
import net.snowflake.client.core.SFOauthLoginInput;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.core.auth.AuthenticatorType;
import net.snowflake.client.jdbc.BaseWiremockTest;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

@Tag(value="core")
public class OAuthTokenCacheLatestIT
extends BaseWiremockTest {
    public static final String MOCK_DPOP_PUBLIC_KEY = "{\"kty\":\"EC\",\"d\":\"j5-J-nLE4J1I8ZWtArP8eQbxUbYMPmRvaEjEkHFlHds\",\"crv\":\"P-256\",\"x\":\"RL5cE-TC4Jr6CxtT4lEI2Yu6wT6LbwojPQsgHUg01F0\",\"y\":\"UAdLUSWTJ6czXaS3SfEFUZzKPcVVq4OZAD8e7Rp75y4\"}";
    private static final String SCENARIOS_BASE_DIR = "/wiremock/mappings/oauth/token_caching";
    private static final String CACHING_TOKENS_AFTER_CONNECTING_SCENARIO_MAPPINGS = "/wiremock/mappings/oauth/token_caching/caching_tokens_after_connecting.json";
    private static final String CACHING_TOKENS_AND_DPOP_KEY_AFTER_CONNECTING_SCENARIO_MAPPINGS = "/wiremock/mappings/oauth/token_caching/caching_tokens_and_dpop_key_after_connecting.json";
    private static final String REUSING_CACHED_ACCESS_TOKEN_SCENARIO_MAPPINGS = "/wiremock/mappings/oauth/token_caching/reusing_cached_access_token_to_authenticate.json";
    private static final String REFRESHING_EXPIRED_ACCESS_TOKEN_SCENARIO_MAPPINGS = "/wiremock/mappings/oauth/token_caching/refreshing_expired_access_token.json";
    private static final String REFRESHING_EXPIRED_ACCESS_TOKEN_SCENARIO_MAPPINGS_DPOP = "/wiremock/mappings/oauth/token_caching/refreshing_expired_access_token_dpop.json";
    private static final String REFRESHING_EXPIRED_ACCESS_TOKEN_SCENARIO_MAPPINGS_DPOP_NONCE_ERROR = "/wiremock/mappings/oauth/token_caching/refreshing_expired_access_token_dpop_nonce_error.json";
    private static final String CACHING_REFRESHED_ACCESS_TOKEN_AND_NEW_REFRESH_TOKEN_SCENARIO_MAPPINGS = "/wiremock/mappings/oauth/token_caching/caching_refreshed_access_token_and_new_refresh_token.json";
    private static final String RESTARTING_FULL_FLOW_ON_EXPIRATION_AND_ERROR_WHEN_REFRESHING = "/wiremock/mappings/oauth/token_caching/restarting_full_flow_on_refresh_token_error.json";
    private static final String RESTARTING_FULL_FLOW_ON_EXPIRATION_AND_NO_REFRESH_TOKEN = "/wiremock/mappings/oauth/token_caching/restarting_full_flow_on_expiration_and_no_refresh_token.json";

    @Test
    public void shouldCacheAccessTokenAfterConnecting() throws SFException, SnowflakeSQLException {
        this.importMappingFromResources(CACHING_TOKENS_AFTER_CONNECTING_SCENARIO_MAPPINGS);
        try (MockedStatic credentialManagerMockedStatic = Mockito.mockStatic(CredentialManager.class);){
            SFLoginInput loginInput = this.createLoginInputStub();
            SessionUtil.openSession((SFLoginInput)loginInput, new HashMap(), (String)"INFO");
            OAuthTokenCacheLatestIT.captureAndAssertSavedTokenValues((MockedStatic<CredentialManager>)credentialManagerMockedStatic, "access-token-123", "refresh-token-123");
        }
    }

    @Test
    public void shouldCacheAccessTokenAndDPoPKeyAfterConnecting() throws SFException, SnowflakeSQLException {
        this.importMappingFromResources(CACHING_TOKENS_AND_DPOP_KEY_AFTER_CONNECTING_SCENARIO_MAPPINGS);
        try (MockedStatic credentialManagerMockedStatic = Mockito.mockStatic(CredentialManager.class);){
            SFLoginInput loginInput = this.createLoginInputStubWithDPoPEnabled();
            SessionUtil.openSession((SFLoginInput)loginInput, new HashMap(), (String)"INFO");
            OAuthTokenCacheLatestIT.captureAndAssertSavedTokenValuesAndDPoPKey((MockedStatic<CredentialManager>)credentialManagerMockedStatic, "access-token-123", "refresh-token-123");
        }
    }

    @Test
    public void shouldReuseCachedAccessTokenWhenConnecting() throws SFException, SnowflakeSQLException {
        this.importMappingFromResources(REUSING_CACHED_ACCESS_TOKEN_SCENARIO_MAPPINGS);
        try (MockedStatic credentialManagerMockedStatic = Mockito.mockStatic(CredentialManager.class);){
            OAuthTokenCacheLatestIT.mockLoadingTokensFromCache((MockedStatic<CredentialManager>)credentialManagerMockedStatic, "reused-access-token-123", "reused-refresh-token-123");
            SFLoginInput loginInput = this.createLoginInputStub();
            SFLoginOutput loginOutput = SessionUtil.openSession((SFLoginInput)loginInput, new HashMap(), (String)"INFO");
            Assertions.assertEquals((Object)"reused-access-token-123", (Object)loginOutput.getOauthAccessToken());
            Assertions.assertEquals((Object)"reused-refresh-token-123", (Object)loginOutput.getOauthRefreshToken());
        }
    }

    @Test
    public void shouldRefreshExpiredAccessTokenAndConnectSuccessfully() throws SFException, SnowflakeSQLException {
        this.importMappingFromResources(REFRESHING_EXPIRED_ACCESS_TOKEN_SCENARIO_MAPPINGS);
        try (MockedStatic credentialManagerMockedStatic = Mockito.mockStatic(CredentialManager.class);){
            OAuthTokenCacheLatestIT.mockLoadingTokensFromCache((MockedStatic<CredentialManager>)credentialManagerMockedStatic, "expired-access-token-123", "some-refresh-token-123");
            SFLoginInput loginInput = this.createLoginInputStub();
            SFLoginOutput loginOutput = SessionUtil.openSession((SFLoginInput)loginInput, new HashMap(), (String)"INFO");
            credentialManagerMockedStatic.verify(() -> CredentialManager.deleteOAuthAccessTokenCacheEntry((SFLoginInput)loginInput), Mockito.times((int)1));
            credentialManagerMockedStatic.verify(() -> CredentialManager.deleteOAuthRefreshTokenCacheEntry((SFLoginInput)loginInput), Mockito.never());
            Assertions.assertEquals((Object)"new-refreshed-access-token-123", (Object)loginOutput.getOauthAccessToken());
            OAuthTokenCacheLatestIT.captureAndAssertSavedTokenValues((MockedStatic<CredentialManager>)credentialManagerMockedStatic, "new-refreshed-access-token-123", "some-refresh-token-123");
        }
    }

    @Test
    public void shouldRefreshExpiredAccessTokenWithDPoPAndConnectSuccessfully() throws SFException, SnowflakeSQLException {
        this.importMappingFromResources(REFRESHING_EXPIRED_ACCESS_TOKEN_SCENARIO_MAPPINGS_DPOP);
        try (MockedStatic credentialManagerMockedStatic = Mockito.mockStatic(CredentialManager.class);){
            OAuthTokenCacheLatestIT.mockLoadingTokensFromCache((MockedStatic<CredentialManager>)credentialManagerMockedStatic, null, "some-refresh-token-123");
            OAuthTokenCacheLatestIT.mockLoadingDPoPPublicKeyFromCache((MockedStatic<CredentialManager>)credentialManagerMockedStatic, "expired-access-token-123");
            SFLoginInput loginInput = this.createLoginInputStubWithDPoPEnabled();
            SFLoginOutput loginOutput = SessionUtil.openSession((SFLoginInput)loginInput, new HashMap(), (String)"INFO");
            credentialManagerMockedStatic.verify(() -> CredentialManager.deleteOAuthAccessTokenCacheEntry((SFLoginInput)loginInput), Mockito.times((int)1));
            credentialManagerMockedStatic.verify(() -> CredentialManager.deleteDPoPBundledAccessTokenCacheEntry((SFLoginInput)loginInput), Mockito.times((int)1));
            credentialManagerMockedStatic.verify(() -> CredentialManager.deleteOAuthRefreshTokenCacheEntry((SFLoginInput)loginInput), Mockito.never());
            Assertions.assertEquals((Object)"new-refreshed-access-token-123", (Object)loginOutput.getOauthAccessToken());
            OAuthTokenCacheLatestIT.captureAndAssertSavedTokenValuesAndDPoPKey((MockedStatic<CredentialManager>)credentialManagerMockedStatic, "new-refreshed-access-token-123", "some-refresh-token-123");
        }
    }

    @Test
    public void shouldRefreshExpiredAccessTokenWithDPoPNonceErrorAndConnectSuccessfully() throws SFException, SnowflakeSQLException {
        this.importMappingFromResources(REFRESHING_EXPIRED_ACCESS_TOKEN_SCENARIO_MAPPINGS_DPOP_NONCE_ERROR);
        try (MockedStatic credentialManagerMockedStatic = Mockito.mockStatic(CredentialManager.class);){
            OAuthTokenCacheLatestIT.mockLoadingTokensFromCache((MockedStatic<CredentialManager>)credentialManagerMockedStatic, null, "some-refresh-token-123");
            OAuthTokenCacheLatestIT.mockLoadingDPoPPublicKeyFromCache((MockedStatic<CredentialManager>)credentialManagerMockedStatic, "expired-access-token-123");
            SFLoginInput loginInput = this.createLoginInputStubWithDPoPEnabled();
            SFLoginOutput loginOutput = SessionUtil.openSession((SFLoginInput)loginInput, new HashMap(), (String)"INFO");
            credentialManagerMockedStatic.verify(() -> CredentialManager.deleteOAuthAccessTokenCacheEntry((SFLoginInput)loginInput), Mockito.times((int)1));
            credentialManagerMockedStatic.verify(() -> CredentialManager.deleteDPoPBundledAccessTokenCacheEntry((SFLoginInput)loginInput), Mockito.times((int)1));
            credentialManagerMockedStatic.verify(() -> CredentialManager.deleteOAuthRefreshTokenCacheEntry((SFLoginInput)loginInput), Mockito.never());
            Assertions.assertEquals((Object)"new-refreshed-access-token-123", (Object)loginOutput.getOauthAccessToken());
            OAuthTokenCacheLatestIT.captureAndAssertSavedTokenValuesAndDPoPKey((MockedStatic<CredentialManager>)credentialManagerMockedStatic, "new-refreshed-access-token-123", "some-refresh-token-123");
        }
    }

    @Test
    public void shouldCacheRefreshedAccessTokenAndNewRefreshToken() throws SFException, SnowflakeSQLException {
        this.importMappingFromResources(CACHING_REFRESHED_ACCESS_TOKEN_AND_NEW_REFRESH_TOKEN_SCENARIO_MAPPINGS);
        try (MockedStatic credentialManagerMockedStatic = Mockito.mockStatic(CredentialManager.class);){
            OAuthTokenCacheLatestIT.mockLoadingTokensFromCache((MockedStatic<CredentialManager>)credentialManagerMockedStatic, "expired-access-token-123", "some-refresh-token-123");
            SFLoginInput loginInput = this.createLoginInputStub();
            SFLoginOutput loginOutput = SessionUtil.openSession((SFLoginInput)loginInput, new HashMap(), (String)"INFO");
            credentialManagerMockedStatic.verify(() -> CredentialManager.deleteOAuthAccessTokenCacheEntry((SFLoginInput)loginInput), Mockito.times((int)1));
            Assertions.assertEquals((Object)"new-refreshed-access-token-123", (Object)loginOutput.getOauthAccessToken());
            OAuthTokenCacheLatestIT.captureAndAssertSavedTokenValues((MockedStatic<CredentialManager>)credentialManagerMockedStatic, "new-refreshed-access-token-123", "new-refresh-token-123");
        }
    }

    @Test
    public void shouldRestartFullFlowOnAccessTokenExpirationAndErrorWhenRefreshing() throws SFException, SnowflakeSQLException {
        this.importMappingFromResources(RESTARTING_FULL_FLOW_ON_EXPIRATION_AND_ERROR_WHEN_REFRESHING);
        try (MockedStatic credentialManagerMockedStatic = Mockito.mockStatic(CredentialManager.class);){
            OAuthTokenCacheLatestIT.mockLoadingTokensFromCache((MockedStatic<CredentialManager>)credentialManagerMockedStatic, "expired-access-token-123", "some-refresh-token-123");
            SFLoginInput loginInput = this.createLoginInputStub();
            SFLoginOutput loginOutput = SessionUtil.openSession((SFLoginInput)loginInput, new HashMap(), (String)"INFO");
            credentialManagerMockedStatic.verify(() -> CredentialManager.deleteOAuthAccessTokenCacheEntry((SFLoginInput)loginInput), Mockito.times((int)1));
            credentialManagerMockedStatic.verify(() -> CredentialManager.deleteOAuthRefreshTokenCacheEntry((SFLoginInput)loginInput), Mockito.times((int)1));
            Assertions.assertEquals((Object)"newly-obtained-access-token-123", (Object)loginOutput.getOauthAccessToken());
            OAuthTokenCacheLatestIT.captureAndAssertSavedTokenValues((MockedStatic<CredentialManager>)credentialManagerMockedStatic, "newly-obtained-access-token-123", "newly-obtained-refresh-token");
        }
    }

    @Test
    public void shouldRestartFullFlowOnAccessTokenExpirationAndNoRefreshToken() throws SFException, SnowflakeSQLException {
        this.importMappingFromResources(RESTARTING_FULL_FLOW_ON_EXPIRATION_AND_NO_REFRESH_TOKEN);
        try (MockedStatic credentialManagerMockedStatic = Mockito.mockStatic(CredentialManager.class);){
            OAuthTokenCacheLatestIT.mockLoadingTokensFromCache((MockedStatic<CredentialManager>)credentialManagerMockedStatic, "expired-access-token-123", null);
            SFLoginInput loginInput = this.createLoginInputStub();
            SFLoginOutput loginOutput = SessionUtil.openSession((SFLoginInput)loginInput, new HashMap(), (String)"INFO");
            credentialManagerMockedStatic.verify(() -> CredentialManager.deleteOAuthAccessTokenCacheEntry((SFLoginInput)loginInput), Mockito.times((int)1));
            credentialManagerMockedStatic.verify(() -> CredentialManager.deleteOAuthRefreshTokenCacheEntry((SFLoginInput)loginInput), Mockito.never());
            Assertions.assertEquals((Object)"newly-obtained-access-token-123", (Object)loginOutput.getOauthAccessToken());
            OAuthTokenCacheLatestIT.captureAndAssertSavedTokenValues((MockedStatic<CredentialManager>)credentialManagerMockedStatic, "newly-obtained-access-token-123", null);
        }
    }

    private SFLoginInput createLoginInputStub() {
        SFLoginInput input = new SFLoginInput();
        input.setAuthenticator(AuthenticatorType.OAUTH_CLIENT_CREDENTIALS.name());
        input.setOriginalAuthenticator(AuthenticatorType.OAUTH_CLIENT_CREDENTIALS.name());
        input.setServerUrl(String.format("http://%s:%d/", "localhost", wiremockHttpPort));
        input.setUserName("MOCK_USERNAME");
        input.setAccountName("MOCK_ACCOUNT_NAME");
        input.setAppId("MOCK_APP_ID");
        input.setAppVersion("MOCK_APP_VERSION");
        input.setOCSPMode(OCSPMode.FAIL_OPEN);
        input.setHttpClientSettingsKey(new HttpClientSettingsKey(OCSPMode.FAIL_OPEN));
        input.setBrowserResponseTimeout(Duration.ofSeconds(20L));
        input.setLoginTimeout(1000);
        input.setSessionParameters(Collections.singletonMap("CLIENT_STORE_TEMPORARY_CREDENTIAL", true));
        input.setOauthLoginInput(new SFOauthLoginInput("123", "123", null, null, String.format("http://%s:%d/oauth/token-request", "localhost", wiremockHttpPort), "session:role:ANALYST"));
        return input;
    }

    private SFLoginInput createLoginInputStubWithDPoPEnabled() {
        SFLoginInput input = this.createLoginInputStub();
        input.setDPoPEnabled(true);
        return input;
    }

    private static void mockLoadingTokensFromCache(MockedStatic<CredentialManager> credentialManagerMock, String oauthAccessToken, String oauthRefreshToken) {
        Answer fillCachedOAuthAccessTokenInvocation = invocation -> {
            ((SFLoginInput)invocation.getArguments()[0]).setOauthAccessToken(oauthAccessToken);
            return null;
        };
        Answer fillCachedOAuthRefreshTokenInvocation = invocation -> {
            ((SFLoginInput)invocation.getArguments()[0]).setOauthRefreshToken(oauthRefreshToken);
            return null;
        };
        credentialManagerMock.when(() -> CredentialManager.fillCachedOAuthAccessToken((SFLoginInput)((SFLoginInput)Mockito.any(SFLoginInput.class)))).then(fillCachedOAuthAccessTokenInvocation);
        credentialManagerMock.when(() -> CredentialManager.fillCachedOAuthRefreshToken((SFLoginInput)((SFLoginInput)Mockito.any(SFLoginInput.class)))).then(fillCachedOAuthRefreshTokenInvocation);
    }

    private static void mockLoadingDPoPPublicKeyFromCache(MockedStatic<CredentialManager> credentialManagerMock, String oauthAccessToken) {
        Answer fillCachedDPoPPublicKeyInvocation = invocation -> {
            ((SFLoginInput)invocation.getArguments()[0]).setOauthAccessToken(oauthAccessToken);
            ((SFLoginInput)invocation.getArguments()[0]).setDPoPPublicKey(MOCK_DPOP_PUBLIC_KEY);
            return null;
        };
        credentialManagerMock.when(() -> CredentialManager.fillCachedDPoPBundledAccessToken((SFLoginInput)((SFLoginInput)Mockito.any(SFLoginInput.class)))).then(fillCachedDPoPPublicKeyInvocation);
    }

    private static void captureAndAssertSavedTokenValues(MockedStatic<CredentialManager> credentialManagerMock, String expectedAccessToken, String expectedRefreshToken) {
        ArgumentCaptor accessTokenInputCaptor = ArgumentCaptor.forClass(SFLoginInput.class);
        credentialManagerMock.verify(() -> CredentialManager.writeOAuthAccessToken((SFLoginInput)((SFLoginInput)accessTokenInputCaptor.capture())));
        Assertions.assertEquals((Object)expectedAccessToken, (Object)((SFLoginInput)accessTokenInputCaptor.getValue()).getOauthAccessToken());
        if (expectedRefreshToken != null) {
            ArgumentCaptor refreshTokenInputCaptor = ArgumentCaptor.forClass(SFLoginInput.class);
            credentialManagerMock.verify(() -> CredentialManager.writeOAuthRefreshToken((SFLoginInput)((SFLoginInput)refreshTokenInputCaptor.capture())));
            Assertions.assertEquals((Object)expectedRefreshToken, (Object)((SFLoginInput)refreshTokenInputCaptor.getValue()).getOauthRefreshToken());
        } else {
            credentialManagerMock.verify(() -> CredentialManager.writeOAuthRefreshToken((SFLoginInput)((SFLoginInput)Mockito.any(SFLoginInput.class))), Mockito.never());
        }
    }

    private static void captureAndAssertSavedTokenValuesAndDPoPKey(MockedStatic<CredentialManager> credentialManagerMock, String expectedAccessToken, String expectedRefreshToken) {
        if (expectedRefreshToken != null) {
            ArgumentCaptor refreshTokenInputCaptor = ArgumentCaptor.forClass(SFLoginInput.class);
            credentialManagerMock.verify(() -> CredentialManager.writeOAuthRefreshToken((SFLoginInput)((SFLoginInput)refreshTokenInputCaptor.capture())));
            Assertions.assertEquals((Object)expectedRefreshToken, (Object)((SFLoginInput)refreshTokenInputCaptor.getValue()).getOauthRefreshToken());
        }
        ArgumentCaptor dpopBundledAccessTokenInputCaptor = ArgumentCaptor.forClass(SFLoginInput.class);
        credentialManagerMock.verify(() -> CredentialManager.writeDPoPBundledAccessToken((SFLoginInput)((SFLoginInput)dpopBundledAccessTokenInputCaptor.capture())));
        Assertions.assertEquals((Object)expectedAccessToken, (Object)((SFLoginInput)dpopBundledAccessTokenInputCaptor.getValue()).getOauthAccessToken());
        Assertions.assertNotNull((Object)((SFLoginInput)dpopBundledAccessTokenInputCaptor.getValue()).getDPoPPublicKey());
    }
}

