/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.util.HashMap;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SFLoginOutput;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.core.auth.AuthenticatorType;
import net.snowflake.client.jdbc.BaseWiremockTest;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="core")
public class ProgrammaticAccessTokenAuthFlowLatestIT
extends BaseWiremockTest {
    private static final String SCENARIOS_BASE_DIR = "/wiremock/mappings/pat";
    private static final String SUCCESSFUL_FLOW_SCENARIO_MAPPINGS = "/wiremock/mappings/pat/successful_flow.json";
    private static final String INVALID_TOKEN_SCENARIO_MAPPINGS = "/wiremock/mappings/pat/invalid_pat_token.json";

    @Test
    public void successfulFlowScenarioPatAsToken() throws SFException, SnowflakeSQLException {
        this.importMappingFromResources(SUCCESSFUL_FLOW_SCENARIO_MAPPINGS);
        SFLoginInput loginInputWithPatAsToken = this.createLoginInputStub("MOCK_TOKEN", null);
        SFLoginOutput loginOutput = SessionUtil.newSession((SFLoginInput)loginInputWithPatAsToken, new HashMap(), (String)"INFO");
        this.assertSuccessfulLoginOutput(loginOutput);
    }

    @Test
    public void successfulFlowScenarioPatAsPassword() throws SFException, SnowflakeSQLException {
        this.importMappingFromResources(SUCCESSFUL_FLOW_SCENARIO_MAPPINGS);
        SFLoginInput loginInputWithPatAsPassword = this.createLoginInputStub(null, "MOCK_TOKEN");
        SFLoginOutput loginOutput = SessionUtil.newSession((SFLoginInput)loginInputWithPatAsPassword, new HashMap(), (String)"INFO");
        this.assertSuccessfulLoginOutput(loginOutput);
    }

    @Test
    public void invalidTokenScenario() {
        this.importMappingFromResources(INVALID_TOKEN_SCENARIO_MAPPINGS);
        SnowflakeSQLException e = (SnowflakeSQLException)Assertions.assertThrows(SnowflakeSQLException.class, () -> SessionUtil.newSession((SFLoginInput)this.createLoginInputStub("MOCK_TOKEN", null), new HashMap(), (String)"INFO"));
        Assertions.assertEquals((Object)"Programmatic access token is invalid.", (Object)e.getMessage());
    }

    private void assertSuccessfulLoginOutput(SFLoginOutput loginOutput) {
        Assertions.assertNotNull((Object)loginOutput);
        Assertions.assertEquals((Object)"session token", (Object)loginOutput.getSessionToken());
        Assertions.assertEquals((Object)"master token", (Object)loginOutput.getMasterToken());
        Assertions.assertEquals((long)14400L, (long)loginOutput.getMasterTokenValidityInSeconds());
        Assertions.assertEquals((Object)"8.48.0", (Object)loginOutput.getDatabaseVersion());
        Assertions.assertEquals((Object)"TEST_DHEYMAN", (Object)loginOutput.getSessionDatabase());
        Assertions.assertEquals((Object)"TEST_JDBC", (Object)loginOutput.getSessionSchema());
        Assertions.assertEquals((Object)"ANALYST", (Object)loginOutput.getSessionRole());
        Assertions.assertEquals((Object)"TEST_XSMALL", (Object)loginOutput.getSessionWarehouse());
        Assertions.assertEquals((Object)"1172562260498", (Object)loginOutput.getSessionId());
        Assertions.assertEquals((int)1, (int)loginOutput.getCommonParams().size());
        Assertions.assertEquals((Object)4, loginOutput.getCommonParams().get("CLIENT_PREFETCH_THREADS"));
    }

    private SFLoginInput createLoginInputStub(String token, String password) {
        SFLoginInput input = new SFLoginInput();
        input.setAuthenticator(AuthenticatorType.PROGRAMMATIC_ACCESS_TOKEN.name());
        input.setServerUrl(String.format("http://%s:%d/", "localhost", wiremockHttpPort));
        input.setUserName("MOCK_USERNAME");
        input.setAccountName("MOCK_ACCOUNT_NAME");
        input.setAppId("MOCK_APP_ID");
        input.setAppVersion("MOCK_APP_VERSION");
        input.setToken(token);
        input.setPassword(password);
        input.setOCSPMode(OCSPMode.FAIL_OPEN);
        input.setHttpClientSettingsKey(new HttpClientSettingsKey(OCSPMode.FAIL_OPEN));
        input.setLoginTimeout(1000);
        input.setSessionParameters(new HashMap());
        return input;
    }
}

