/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import net.snowflake.client.core.QueryContextCache;
import net.snowflake.client.core.QueryContextDTO;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class QueryContextCacheTest {
    private QueryContextCache qcc = null;
    private long BASE_READ_TIMESTAMP = 1668727958L;
    private String CONTEXT = "Some query context";
    private long BASE_ID = 0L;
    private long BASE_PRIORITY = 0L;
    private int MAX_CAPACITY = 5;
    private long[] expectedIDs;
    private long[] expectedReadTimestamp;
    private long[] expectedPriority;

    private void initCache() {
        this.qcc = new QueryContextCache(this.MAX_CAPACITY);
    }

    private void initCacheWithData() {
        this.initCacheWithDataWithContext(this.CONTEXT);
    }

    private void initCacheWithDataWithContext(String context) {
        this.qcc = new QueryContextCache(this.MAX_CAPACITY);
        this.expectedIDs = new long[this.MAX_CAPACITY];
        this.expectedReadTimestamp = new long[this.MAX_CAPACITY];
        this.expectedPriority = new long[this.MAX_CAPACITY];
        for (int i = 0; i < this.MAX_CAPACITY; ++i) {
            this.expectedIDs[i] = this.BASE_ID + (long)i;
            this.expectedReadTimestamp[i] = this.BASE_READ_TIMESTAMP + (long)i;
            this.expectedPriority[i] = this.BASE_PRIORITY + (long)i;
            this.qcc.merge(this.expectedIDs[i], this.expectedReadTimestamp[i], this.expectedPriority[i], context);
        }
        this.qcc.syncPriorityMap();
    }

    private void initCacheWithDataInRandomOrder() {
        this.qcc = new QueryContextCache(this.MAX_CAPACITY);
        this.expectedIDs = new long[this.MAX_CAPACITY];
        this.expectedReadTimestamp = new long[this.MAX_CAPACITY];
        this.expectedPriority = new long[this.MAX_CAPACITY];
        for (int i = 0; i < this.MAX_CAPACITY; ++i) {
            this.expectedIDs[i] = this.BASE_ID + (long)i;
            this.expectedReadTimestamp[i] = this.BASE_READ_TIMESTAMP + (long)i;
            this.expectedPriority[i] = this.BASE_PRIORITY + (long)i;
        }
        this.qcc.merge(this.expectedIDs[3], this.expectedReadTimestamp[3], this.expectedPriority[3], this.CONTEXT);
        this.qcc.merge(this.expectedIDs[2], this.expectedReadTimestamp[2], this.expectedPriority[2], this.CONTEXT);
        this.qcc.merge(this.expectedIDs[4], this.expectedReadTimestamp[4], this.expectedPriority[4], this.CONTEXT);
        this.qcc.merge(this.expectedIDs[0], this.expectedReadTimestamp[0], this.expectedPriority[0], this.CONTEXT);
        this.qcc.merge(this.expectedIDs[1], this.expectedReadTimestamp[1], this.expectedPriority[1], this.CONTEXT);
        this.qcc.syncPriorityMap();
    }

    @Test
    public void testIsEmpty() throws Exception {
        this.initCache();
        MatcherAssert.assertThat((String)"Empty cache", (this.qcc.getSize() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testWithSomeData() throws Exception {
        this.initCacheWithData();
        this.assertCacheData();
    }

    @Test
    public void testWithSomeDataInRandomOrder() throws Exception {
        this.initCacheWithDataInRandomOrder();
        this.assertCacheData();
    }

    @Test
    public void testMoreThanCapacity() throws Exception {
        this.initCacheWithData();
        int i = this.MAX_CAPACITY;
        this.qcc.merge(this.BASE_ID + (long)i, this.BASE_READ_TIMESTAMP + (long)i, this.BASE_PRIORITY + (long)i, this.CONTEXT);
        this.qcc.syncPriorityMap();
        this.qcc.checkCacheCapacity();
        this.assertCacheData();
    }

    @Test
    public void testUpdateTimestamp() throws Exception {
        this.initCacheWithData();
        int updatedID = 1;
        this.expectedReadTimestamp[updatedID] = this.BASE_READ_TIMESTAMP + (long)updatedID + 10L;
        this.qcc.merge(this.BASE_ID + (long)updatedID, this.expectedReadTimestamp[updatedID], this.BASE_PRIORITY + (long)updatedID, this.CONTEXT);
        this.qcc.syncPriorityMap();
        this.qcc.checkCacheCapacity();
        this.assertCacheData();
    }

    @Test
    public void testUpdatePriority() throws Exception {
        long updatedPriority;
        this.initCacheWithData();
        int updatedID = 3;
        this.expectedPriority[updatedID] = updatedPriority = this.BASE_PRIORITY + (long)updatedID + 7L;
        this.qcc.merge(this.BASE_ID + (long)updatedID, this.BASE_READ_TIMESTAMP + (long)updatedID, this.expectedPriority[updatedID], this.CONTEXT);
        this.qcc.syncPriorityMap();
        this.qcc.checkCacheCapacity();
        for (int i = updatedID; i < this.MAX_CAPACITY - 1; ++i) {
            this.expectedIDs[i] = this.expectedIDs[i + 1];
            this.expectedReadTimestamp[i] = this.expectedReadTimestamp[i + 1];
            this.expectedPriority[i] = this.expectedPriority[i + 1];
        }
        this.expectedIDs[this.MAX_CAPACITY - 1] = this.BASE_ID + (long)updatedID;
        this.expectedReadTimestamp[this.MAX_CAPACITY - 1] = this.BASE_READ_TIMESTAMP + (long)updatedID;
        this.expectedPriority[this.MAX_CAPACITY - 1] = updatedPriority;
        this.assertCacheData();
    }

    @Test
    public void testAddSamePriority() throws Exception {
        this.initCacheWithData();
        int i = this.MAX_CAPACITY;
        long UpdatedPriority = this.BASE_PRIORITY + 1L;
        this.qcc.merge(this.BASE_ID + (long)i, this.BASE_READ_TIMESTAMP + (long)i, UpdatedPriority, this.CONTEXT);
        this.qcc.syncPriorityMap();
        this.qcc.checkCacheCapacity();
        this.expectedIDs[1] = this.BASE_ID + (long)i;
        this.expectedReadTimestamp[1] = this.BASE_READ_TIMESTAMP + (long)i;
        this.assertCacheData();
    }

    @Test
    public void testAddSameIDButStaleTimestamp() throws Exception {
        this.initCacheWithData();
        int i = 2;
        this.qcc.merge(this.BASE_ID + (long)i, this.BASE_READ_TIMESTAMP + (long)i - 10L, this.BASE_PRIORITY + (long)i, this.CONTEXT);
        this.qcc.syncPriorityMap();
        this.qcc.checkCacheCapacity();
        this.assertCacheData();
    }

    @Test
    public void testEmptyCacheWithNullData() throws Exception {
        this.initCacheWithData();
        this.qcc.deserializeQueryContextJson(null);
        MatcherAssert.assertThat((String)"Empty cache", (this.qcc.getSize() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEmptyCacheWithEmptyResponseData() throws Exception {
        this.initCacheWithData();
        this.qcc.deserializeQueryContextJson("");
        MatcherAssert.assertThat((String)"Empty cache", (this.qcc.getSize() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSerializeRequestAndDeserializeResponseData() throws Exception {
        this.initCacheWithData();
        this.assertCacheData();
        QueryContextDTO requestData = this.qcc.serializeQueryContextDTO();
        this.qcc.clearCache();
        MatcherAssert.assertThat((String)"Empty cache", (this.qcc.getSize() == 0 ? 1 : 0) != 0);
        this.qcc.deserializeQueryContextDTO(requestData);
        this.assertCacheData();
    }

    @Test
    public void testSerializeRequestAndDeserializeResponseDataWithNullContext() throws Exception {
        this.initCacheWithDataWithContext(null);
        this.assertCacheDataWithContext(null);
        QueryContextDTO requestData = this.qcc.serializeQueryContextDTO();
        this.qcc.clearCache();
        MatcherAssert.assertThat((String)"Empty cache", (this.qcc.getSize() == 0 ? 1 : 0) != 0);
        this.qcc.deserializeQueryContextDTO(requestData);
        this.assertCacheDataWithContext(null);
        QueryContextCache mockQcc = (QueryContextCache)Mockito.spy((Object)this.qcc);
        mockQcc.deserializeQueryContextDTO(null);
        ((QueryContextCache)Mockito.verify((Object)mockQcc)).clearCache();
        ((QueryContextCache)Mockito.verify((Object)mockQcc, (VerificationMode)Mockito.times((int)2))).logCacheEntries();
    }

    private void assertCacheData() {
        this.assertCacheDataWithContext(this.CONTEXT);
    }

    private void assertCacheDataWithContext(String context) {
        int size = this.qcc.getSize();
        MatcherAssert.assertThat((String)"Non empty cache", (size == this.MAX_CAPACITY ? 1 : 0) != 0);
        long[] ids = new long[size];
        long[] readTimestamps = new long[size];
        long[] priorities = new long[size];
        String[] contexts = new String[size];
        this.qcc.getElements(ids, readTimestamps, priorities, contexts);
        for (int i = 0; i < size; ++i) {
            Assertions.assertEquals((long)this.expectedIDs[i], (long)ids[i]);
            Assertions.assertEquals((long)this.expectedReadTimestamp[i], (long)readTimestamps[i]);
            Assertions.assertEquals((long)this.expectedPriority[i], (long)priorities[i]);
            Assertions.assertEquals((Object)context, (Object)contexts[i]);
        }
    }
}

