/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.nio.file.Paths;
import net.snowflake.client.annotations.RunOnLinux;
import net.snowflake.client.annotations.RunOnMac;
import net.snowflake.client.annotations.RunOnWindows;
import net.snowflake.client.annotations.RunOnWindowsOrMac;
import net.snowflake.client.core.CachedCredentialType;
import net.snowflake.client.core.Constants;
import net.snowflake.client.core.MockAdvapi32Lib;
import net.snowflake.client.core.MockSecurityLib;
import net.snowflake.client.core.SecureStorageAppleManager;
import net.snowflake.client.core.SecureStorageLinuxManager;
import net.snowflake.client.core.SecureStorageManager;
import net.snowflake.client.core.SecureStorageWindowsManager;
import net.snowflake.client.jdbc.SnowflakeUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class SecureStorageManagerTest {
    private static final String host = "fakeHost";
    private static final String user = "fakeUser";
    private static final String idToken = "fakeIdToken";
    private static final String idToken0 = "fakeIdToken0";
    private static final String mfaToken = "fakeMfaToken";
    private static final String ID_TOKEN = "ID_TOKEN";
    private static final String MFA_TOKEN = "MFATOKEN";

    @Test
    public void testBuildCredentialsKey() {
        String hashedKey = SecureStorageManager.buildCredentialsKey((String)host, (String)user, (String)CachedCredentialType.OAUTH_ACCESS_TOKEN.getValue());
        Assertions.assertEquals((Object)"A7C7EBB89312E88552CD00664A0E20929801FACFBD682BF7C2363FB6EC8F914E", (Object)hashedKey);
        hashedKey = SecureStorageManager.buildCredentialsKey((String)host, (String)user, (String)CachedCredentialType.OAUTH_REFRESH_TOKEN.getValue());
        Assertions.assertEquals((Object)"DB37028833FA02B125FBD6DE8CE679C7E62E7D38FAC585E98060E00987F96772", (Object)hashedKey);
        hashedKey = SecureStorageManager.buildCredentialsKey((String)host, (String)user, (String)CachedCredentialType.ID_TOKEN.getValue());
        Assertions.assertEquals((Object)"6AA3F783E07D1D2182DAB59442806E2433C55C2BD4D9240790FD5B4B91FD4FDB", (Object)hashedKey);
        hashedKey = SecureStorageManager.buildCredentialsKey((String)host, (String)user, (String)CachedCredentialType.MFA_TOKEN.getValue());
        Assertions.assertEquals((Object)"9D10D4EFE45605D85993C6AC95334F1B63D36611B83615656EC7F277A947BF4B", (Object)hashedKey);
    }

    @Test
    @RunOnWindowsOrMac
    public void testLoadNativeLibrary() {
        if (Constants.getOS() == Constants.OS.MAC) {
            MatcherAssert.assertThat((Object)SecureStorageAppleManager.SecurityLibManager.getInstance(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
        if (Constants.getOS() == Constants.OS.WINDOWS) {
            MatcherAssert.assertThat((Object)SecureStorageWindowsManager.Advapi32LibManager.getInstance(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    @RunOnWindows
    public void testWindowsManager() {
        SecureStorageWindowsManager.Advapi32LibManager.setInstance((SecureStorageWindowsManager.Advapi32Lib)new MockAdvapi32Lib());
        SecureStorageWindowsManager manager = SecureStorageWindowsManager.builder();
        this.testBody((SecureStorageManager)manager);
        SecureStorageWindowsManager.Advapi32LibManager.resetInstance();
    }

    @Test
    @RunOnMac
    public void testMacManager() {
        SecureStorageAppleManager.SecurityLibManager.setInstance((SecureStorageAppleManager.SecurityLib)new MockSecurityLib());
        SecureStorageAppleManager manager = SecureStorageAppleManager.builder();
        this.testBody((SecureStorageManager)manager);
        SecureStorageAppleManager.SecurityLibManager.resetInstance();
    }

    @Test
    @RunOnLinux
    public void testLinuxManager() {
        String cacheDirectory = Paths.get(SnowflakeUtil.systemGetProperty((String)"user.home"), ".cache", "snowflake_test_cache").toAbsolutePath().toString();
        try (MockedStatic snowflakeUtilMockedStatic = Mockito.mockStatic(SnowflakeUtil.class);){
            snowflakeUtilMockedStatic.when(() -> SnowflakeUtil.systemGetProperty((String)"net.snowflake.jdbc.temporaryCredentialCacheDir")).thenReturn((Object)cacheDirectory);
            SecureStorageLinuxManager manager = SecureStorageLinuxManager.getInstance();
            this.testBody((SecureStorageManager)manager);
            this.testDeleteLinux((SecureStorageManager)manager);
        }
    }

    private void testBody(SecureStorageManager manager) {
        MatcherAssert.assertThat((Object)manager.deleteCredential(host, user, ID_TOKEN), (Matcher)CoreMatchers.equalTo((Object)SecureStorageManager.SecureStorageStatus.SUCCESS));
        MatcherAssert.assertThat((Object)manager.getCredential(host, user, ID_TOKEN), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)manager.setCredential(host, user, ID_TOKEN, idToken), (Matcher)CoreMatchers.equalTo((Object)SecureStorageManager.SecureStorageStatus.SUCCESS));
        MatcherAssert.assertThat((Object)manager.getCredential(host, user, ID_TOKEN), (Matcher)CoreMatchers.equalTo((Object)idToken));
        MatcherAssert.assertThat((Object)manager.setCredential(host, user, ID_TOKEN, idToken0), (Matcher)CoreMatchers.equalTo((Object)SecureStorageManager.SecureStorageStatus.SUCCESS));
        MatcherAssert.assertThat((Object)manager.getCredential(host, user, ID_TOKEN), (Matcher)CoreMatchers.equalTo((Object)idToken0));
        MatcherAssert.assertThat((Object)manager.deleteCredential(host, user, ID_TOKEN), (Matcher)CoreMatchers.equalTo((Object)SecureStorageManager.SecureStorageStatus.SUCCESS));
        MatcherAssert.assertThat((Object)manager.getCredential(host, user, ID_TOKEN), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private void testDeleteLinux(SecureStorageManager manager) {
        MatcherAssert.assertThat((Object)manager.setCredential(host, user, ID_TOKEN, idToken), (Matcher)CoreMatchers.equalTo((Object)SecureStorageManager.SecureStorageStatus.SUCCESS));
        MatcherAssert.assertThat((Object)manager.setCredential(host, user, MFA_TOKEN, mfaToken), (Matcher)CoreMatchers.equalTo((Object)SecureStorageManager.SecureStorageStatus.SUCCESS));
        MatcherAssert.assertThat((Object)manager.getCredential(host, user, ID_TOKEN), (Matcher)CoreMatchers.equalTo((Object)idToken));
        MatcherAssert.assertThat((Object)manager.getCredential(host, user, MFA_TOKEN), (Matcher)CoreMatchers.equalTo((Object)mfaToken));
        MatcherAssert.assertThat((Object)manager.deleteCredential(host, user, ID_TOKEN), (Matcher)CoreMatchers.equalTo((Object)SecureStorageManager.SecureStorageStatus.SUCCESS));
        MatcherAssert.assertThat((Object)manager.getCredential(host, user, ID_TOKEN), (Matcher)CoreMatchers.equalTo(null));
        MatcherAssert.assertThat((Object)manager.getCredential(host, user, MFA_TOKEN), (Matcher)CoreMatchers.equalTo((Object)mfaToken));
        MatcherAssert.assertThat((Object)manager.deleteCredential(host, user, MFA_TOKEN), (Matcher)CoreMatchers.equalTo((Object)SecureStorageManager.SecureStorageStatus.SUCCESS));
    }
}

