/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BooleanNode;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFTrustManager;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.core.SystemUtil;
import net.snowflake.client.core.auth.AuthenticatorType;
import net.snowflake.client.jdbc.MockConnectionTest;
import net.snowflake.client.jdbc.SnowflakeUtil;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class SessionUtilTest {
    private static String originalUrlValue;
    private static String originalRetryUrlPattern;

    @BeforeAll
    public static void saveStaticValues() {
        originalUrlValue = SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_URL_VALUE;
        originalRetryUrlPattern = SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN;
    }

    @AfterAll
    public static void restoreStaticValues() {
        SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_URL_VALUE = originalUrlValue;
        SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN = originalRetryUrlPattern;
    }

    @Test
    public void testIsPrefixEqual() throws Exception {
        MatcherAssert.assertThat((String)"no port number", (boolean)SessionUtil.isPrefixEqual((String)"https://testaccount.snowflakecomputing.com/blah", (String)"https://testaccount.snowflakecomputing.com/"));
        MatcherAssert.assertThat((String)"no port number with a slash", (boolean)SessionUtil.isPrefixEqual((String)"https://testaccount.snowflakecomputing.com/blah", (String)"https://testaccount.snowflakecomputing.com"));
        MatcherAssert.assertThat((String)"including a port number on one of them", (boolean)SessionUtil.isPrefixEqual((String)"https://testaccount.snowflakecomputing.com/blah", (String)"https://testaccount.snowflakecomputing.com:443/"));
        MatcherAssert.assertThat((String)"different hostnames", (!SessionUtil.isPrefixEqual((String)"https://testaccount1.snowflakecomputing.com/blah", (String)"https://testaccount2.snowflakecomputing.com/") ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"different port numbers", (!SessionUtil.isPrefixEqual((String)"https://testaccount.snowflakecomputing.com:123/blah", (String)"https://testaccount.snowflakecomputing.com:443/") ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"different protocols", (!SessionUtil.isPrefixEqual((String)"http://testaccount.snowflakecomputing.com/blah", (String)"https://testaccount.snowflakecomputing.com/") ? 1 : 0) != 0);
    }

    @Test
    public void testParameterParsing() {
        HashMap<String, BooleanNode> parameterMap = new HashMap<String, BooleanNode>();
        parameterMap.put("other_parameter", BooleanNode.getTrue());
        SFBaseSession session = new MockConnectionTest.MockSnowflakeConnectionImpl().getSFSession();
        SessionUtil.updateSfDriverParamValues(parameterMap, (SFBaseSession)session);
        Assertions.assertTrue((boolean)((BooleanNode)session.getOtherParameter("other_parameter")).asBoolean());
    }

    @Test
    public void testConvertSystemPropertyToIntValue() {
        try {
            System.setProperty("net.snowflake.jdbc.max_connections", "500");
            Assertions.assertEquals((int)500, (int)SystemUtil.convertSystemPropertyToIntValue((String)"net.snowflake.jdbc.max_connections", (int)300));
            System.setProperty("net.snowflake.jdbc.max_connections", "notAnInteger");
            Assertions.assertEquals((int)300, (int)SystemUtil.convertSystemPropertyToIntValue((String)"net.snowflake.jdbc.max_connections", (int)300));
            System.setProperty("net.snowflake.jdbc.max_connections_per_route", "30");
            Assertions.assertEquals((int)30, (int)SystemUtil.convertSystemPropertyToIntValue((String)"net.snowflake.jdbc.max_connections_per_route", (int)300));
        }
        finally {
            System.clearProperty("net.snowflake.jdbc.max_connections");
            System.clearProperty("net.snowflake.jdbc.max_connections_per_route");
        }
    }

    @Test
    public void testIsLoginRequest() {
        ArrayList<String> testCases = new ArrayList<String>();
        testCases.add("/session/v1/login-request");
        testCases.add("/session/token-request");
        testCases.add("/session/authenticator-request");
        for (String testCase : testCases) {
            try {
                URIBuilder uriBuilder = new URIBuilder("https://test.snowflakecomputing.com");
                uriBuilder.setPath(testCase);
                URI uri = uriBuilder.build();
                HttpPost postRequest = new HttpPost(uri);
                Assertions.assertTrue((boolean)SessionUtil.isNewRetryStrategyRequest((HttpRequestBase)postRequest));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Test
    public void testIsLoginRequestInvalidURIPath() {
        ArrayList<String> testCases = new ArrayList<String>();
        testCases.add("/session/not-a-real-path");
        for (String testCase : testCases) {
            try {
                URIBuilder uriBuilder = new URIBuilder("https://test.snowflakecomputing.com");
                uriBuilder.setPath(testCase);
                URI uri = uriBuilder.build();
                HttpPost postRequest = new HttpPost(uri);
                Assertions.assertFalse((boolean)SessionUtil.isNewRetryStrategyRequest((HttpRequestBase)postRequest));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Test
    public void shouldDerivePrivateLinkOcspCacheServerUrlBasedOnHost() throws IOException {
        this.resetOcspConfiguration();
        SessionUtil.resetOCSPUrlIfNecessary((String)"https://test.privatelink.snowflakecomputing.com");
        Assertions.assertEquals((Object)"http://ocsp.test.privatelink.snowflakecomputing.com/ocsp_response_cache.json", (Object)SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_URL_VALUE);
        Assertions.assertEquals((Object)"http://ocsp.test.privatelink.snowflakecomputing.com/retry/%s/%s", (Object)SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN);
        this.resetOcspConfiguration();
        SessionUtil.resetOCSPUrlIfNecessary((String)"https://test.privatelink.snowflakecomputing.cn");
        Assertions.assertEquals((Object)"http://ocsp.test.privatelink.snowflakecomputing.cn/ocsp_response_cache.json", (Object)SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_URL_VALUE);
        Assertions.assertEquals((Object)"http://ocsp.test.privatelink.snowflakecomputing.cn/retry/%s/%s", (Object)SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN);
        this.resetOcspConfiguration();
        SessionUtil.resetOCSPUrlIfNecessary((String)"https://test.privatelink.snowflakecomputing.xyz");
        Assertions.assertEquals((Object)"http://ocsp.test.privatelink.snowflakecomputing.xyz/ocsp_response_cache.json", (Object)SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_URL_VALUE);
        Assertions.assertEquals((Object)"http://ocsp.test.privatelink.snowflakecomputing.xyz/retry/%s/%s", (Object)SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN);
    }

    @Test
    public void testGetCommonParams() throws Exception {
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        Map result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"testParam\", \"value\": true}]"));
        Assertions.assertTrue((boolean)((Boolean)result.get("testParam")));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"testParam\", \"value\": false}]"));
        Assertions.assertFalse((boolean)((Boolean)result.get("testParam")));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"testParam\", \"value\": 0}]"));
        Assertions.assertEquals((int)0, (int)((Integer)result.get("testParam")));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"testParam\", \"value\": 1000}]"));
        Assertions.assertEquals((int)1000, (int)((Integer)result.get("testParam")));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"testParam\", \"value\": \"\"}]"));
        Assertions.assertEquals((Object)"", result.get("testParam"));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"testParam\", \"value\": \"value\"}]"));
        Assertions.assertEquals((Object)"value", result.get("testParam"));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"CLIENT_DISABLE_INCIDENTS\", \"value\": true}]"));
        Assertions.assertTrue((boolean)((Boolean)result.get("CLIENT_DISABLE_INCIDENTS")));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"CLIENT_DISABLE_INCIDENTS\", \"value\": false}]"));
        Assertions.assertFalse((boolean)((Boolean)result.get("CLIENT_DISABLE_INCIDENTS")));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"CLIENT_STAGE_ARRAY_BINDING_THRESHOLD\", \"value\": 0}]"));
        Assertions.assertEquals((int)0, (int)((Integer)result.get("CLIENT_STAGE_ARRAY_BINDING_THRESHOLD")));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"CLIENT_STAGE_ARRAY_BINDING_THRESHOLD\", \"value\": 1000}]"));
        Assertions.assertEquals((int)1000, (int)((Integer)result.get("CLIENT_STAGE_ARRAY_BINDING_THRESHOLD")));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"TIMEZONE\", \"value\": \"\"}]"));
        Assertions.assertEquals((Object)"", result.get("TIMEZONE"));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"TIMEZONE\", \"value\": \"value\"}]"));
        Assertions.assertEquals((Object)"value", result.get("TIMEZONE"));
    }

    @Test
    public void shouldProperlyCheckIfExperimentalAuthEnabled() {
        try (MockedStatic snowflakeUtilMockedStatic = Mockito.mockStatic(SnowflakeUtil.class);){
            snowflakeUtilMockedStatic.when(() -> SnowflakeUtil.systemGetEnv((String)"SF_ENABLE_EXPERIMENTAL_AUTHENTICATION")).thenReturn(null);
            Assertions.assertThrows(SFException.class, () -> SessionUtil.checkIfExperimentalAuthnEnabled((AuthenticatorType)AuthenticatorType.OAUTH_AUTHORIZATION_CODE));
            Assertions.assertThrows(SFException.class, () -> SessionUtil.checkIfExperimentalAuthnEnabled((AuthenticatorType)AuthenticatorType.OAUTH_CLIENT_CREDENTIALS));
            Assertions.assertThrows(SFException.class, () -> SessionUtil.checkIfExperimentalAuthnEnabled((AuthenticatorType)AuthenticatorType.PROGRAMMATIC_ACCESS_TOKEN));
            snowflakeUtilMockedStatic.when(() -> SnowflakeUtil.systemGetEnv((String)"SF_ENABLE_EXPERIMENTAL_AUTHENTICATION")).thenReturn((Object)"true");
            Assertions.assertDoesNotThrow(() -> SessionUtil.checkIfExperimentalAuthnEnabled((AuthenticatorType)AuthenticatorType.OAUTH_AUTHORIZATION_CODE));
            Assertions.assertDoesNotThrow(() -> SessionUtil.checkIfExperimentalAuthnEnabled((AuthenticatorType)AuthenticatorType.OAUTH_CLIENT_CREDENTIALS));
            Assertions.assertDoesNotThrow(() -> SessionUtil.checkIfExperimentalAuthnEnabled((AuthenticatorType)AuthenticatorType.PROGRAMMATIC_ACCESS_TOKEN));
        }
    }

    private void resetOcspConfiguration() {
        SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_URL_VALUE = null;
        SFTrustManager.SF_OCSP_RESPONSE_CACHE_SERVER_RETRY_URL_PATTERN = null;
    }

    @Test
    public void testOktaAuthRequestsAreRetriedUsingLoginRetryStrategy() {
        String oktaSSOAuthPath = "api/v1/authn";
        String oktaTokenAuthPath = "app/snowflake/tokenlikepartofurl/sso/saml";
        ArrayList<String> oktaAuthURLs = new ArrayList<String>();
        oktaAuthURLs.add("https://anytestpath.okta.com");
        oktaAuthURLs.add("https://vanity-url.somecompany.com");
        for (String oktaAuthURL : oktaAuthURLs) {
            try {
                this.assertThatPathIsRecognizedAsNewRetryStrategy(oktaAuthURL, "api/v1/authn");
                this.assertThatPathIsRecognizedAsNewRetryStrategy(oktaAuthURL, "app/snowflake/tokenlikepartofurl/sso/saml");
            }
            catch (URISyntaxException e) {
                Assertions.fail((String)("Test case data cannot be treated as a valid URL and path. Check test input data. Error: " + e.getMessage()));
            }
        }
    }

    private void assertThatPathIsRecognizedAsNewRetryStrategy(String uriToTest, String pathToTest) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(uriToTest);
        uriBuilder.setPath(pathToTest);
        URI uri = uriBuilder.build();
        HttpPost postRequest = new HttpPost(uri);
        MatcherAssert.assertThat((String)"New retry strategy (designed to serve login-like requests) should be used for okta authn endpoint authentication.", (boolean)SessionUtil.isNewRetryStrategyRequest((HttpRequestBase)postRequest));
    }
}

